<?php
// BLYXCORE - USER DASHBOARD UI (UNIVERSAL SENDER EDITION)

// =================================================================
// BÖLÜM 1: İŞLEM GEÇMİŞİ
// =================================================================
add_action('um_before_account_general', 'blyxxa_inject_history_dashboard');
// Helper: Get User History
function blyxxa_get_user_history($uid, $search_query = '', $page = 1, $per_page = 5) {
    $history = get_user_meta($uid, 'blyxxa_history', true);
    if (!is_array($history)) $history = [];

    if ($search_query) {
        $history = array_filter($history, function($item) use ($search_query) {
            $title = isset($item['title']) ? $item['title'] : '';
            $content = isset($item['content']) ? $item['content'] : '';
            return (stripos($title, $search_query) !== false || stripos($content, $search_query) !== false);
        });
    }

    $total_items = count($history);
    $total_pages = ceil($total_items / $per_page);
    if ($page > $total_pages && $total_pages > 0) $page = $total_pages;
    $offset = ($page - 1) * $per_page;
    $items = array_slice($history, $offset, $per_page, true);

    return [
        'items' => $items,
        'total_items' => $total_items,
        'total_pages' => $total_pages,
        'current_page' => $page
    ];
}

function blyxxa_inject_history_dashboard($return = false, $per_page = 5) {
    $uid = get_current_user_id();

    // Handle Deletion
    if(isset($_POST['delete_history']) && isset($_POST['history_index']) && wp_verify_nonce($_POST['blyx_hist_nonce'], 'delete_history')) {
        $full_history = get_user_meta($uid, 'blyxxa_history', true);
        if(is_array($full_history)) {
            unset($full_history[intval($_POST['history_index'])]);
            $full_history = array_values($full_history);
            update_user_meta($uid, 'blyxxa_history', $full_history);
        }
    }

    $search_query = isset($_GET['blyx_q']) ? sanitize_text_field(wp_unslash($_GET['blyx_q'])) : '';
    $current_page = isset($_GET['blyx_p']) ? max(1, intval(wp_unslash($_GET['blyx_p']))) : 1;
    
    $data = blyxxa_get_user_history($uid, $search_query, $current_page, $per_page);
    $visible_items = $data['items'];
    $total_items = $data['total_items'];
    $total_pages = $data['total_pages'];

    if($return) ob_start();
    ?>
    <div class="um-field" style="margin-bottom: 30px; background: #fff; border: 1px solid #e5e5e5; border-radius: 6px; box-shadow: 0 2px 5px rgba(0,0,0,0.03);">
        <div style="padding: 15px; border-bottom: 1px solid #eee; background: #fafafa; border-radius: 6px 6px 0 0; display: flex; flex-wrap: wrap; align-items: center; justify-content: space-between; gap: 10px;">
            <h4 style="margin: 0; color: #333; font-size: 15px;">
                📂 <?php echo esc_html__('Saved Projects', 'blyxxa-core'); ?> <span style="font-size:11px; color:#999; font-weight:normal;">(<?php echo esc_html($total_items); ?>)</span>
            </h4>
            <form method="get" style="margin:0; display:flex; align-items:center; gap:5px;">
                <input type="text" name="blyx_q" value="<?php echo esc_attr($search_query); ?>" placeholder="<?php echo esc_attr__('Search...', 'blyxxa-core'); ?>" style="padding: 6px 10px; border: 1px solid #ddd; border-radius: 4px; font-size: 13px; width: 140px;">
                <?php if($search_query): ?>
                    <a href="<?php echo esc_url(remove_query_arg(array('blyx_q', 'blyx_p'))); ?>" style="text-decoration:none; color:#dc3545; font-size:16px; font-weight:bold;" title="<?php echo esc_attr__('Clear', 'blyxxa-core'); ?>">×</a>
                <?php endif; ?>
                <button type="submit" style="display:none;"></button> </form>
        </div>
        
        <div style="padding: 15px; min-height: 200px;"> <?php if(empty($visible_items)): ?>
                <div style="text-align:center; padding: 30px; color:#999;">
                    <?php if($search_query): ?>
                        ❌ <?php echo esc_html__('No results found for', 'blyxxa-core'); ?> "<strong><?php echo esc_html($search_query); ?></strong>"
                    <?php else: ?>
                         📭 <?php echo esc_html__('No saved history yet.', 'blyxxa-core'); ?>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <?php foreach($visible_items as $original_index => $item): 
                    $title = isset($item['title']) ? $item['title'] : esc_html__('Untitled Project', 'blyxxa-core');
                    $date = isset($item['date']) ? $item['date'] : '-';
                    $content = isset($item['content']) ? $item['content'] : '';
                    $uniq = 'h_' . $original_index; 
                ?>
                <div style="border: 1px solid #eee; border-radius: 4px; margin-bottom: 8px; overflow:hidden;">
                    <div onclick="var el=document.getElementById('<?php echo esc_js($uniq); ?>'); el.style.display=(el.style.display=='none')?'block':'none';" style="padding: 12px 15px; cursor: pointer; display: flex; justify-content: space-between; align-items: center; background: #fff; transition: background 0.2s;" onmouseover="this.style.background='#f9f9f9'" onmouseout="this.style.background='#fff'">
                        <div style="display:flex; align-items:center; gap:8px;">
                            <span style="font-size:14px;">📄</span>
                            <strong style="font-size: 13px; color: #007bff;"><?php echo esc_html($title); ?></strong>
                        </div>
                        <span style="font-size: 11px; color: #aaa;"><?php echo esc_html($date); ?> ▼</span>
                    </div>
                    <div id="<?php echo esc_attr($uniq); ?>" style="display:none; padding: 20px; border-top: 1px solid #f0f0f0; background: #fcfcfc; font-size: 13px; line-height: 1.6;">
                        <?php echo wp_kses_post($content); ?>
                        <form method="post" style="margin-top:15px; border-top:1px dashed #eee; padding-top:10px; text-align:right;">
                            <?php wp_nonce_field('delete_history', 'blyx_hist_nonce'); ?>
                            <input type="hidden" name="history_index" value="<?php echo esc_attr($original_index); ?>">
                            <button type="submit" name="delete_history" onclick="return confirm('<?php echo esc_js(__('Are you sure you want to delete this?', 'blyxxa-core')); ?>')" style="background:none; border:none; color:#dc3545; cursor:pointer; font-size:12px; text-decoration:underline;">
                                🗑️ <?php echo esc_html__('Delete Record', 'blyxxa-core'); ?>
                            </button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <?php if($total_pages > 1): ?>
        <div style="padding: 10px 15px; border-top: 1px solid #eee; background: #fafafa; border-radius: 0 0 6px 6px; display:flex; justify-content:center; gap:5px;">
            <?php 
            $base_url = add_query_arg('blyx_q', $search_query);
            if($current_page > 1) { echo '<a href="'.esc_url(add_query_arg('blyx_p', $current_page-1, $base_url)).'" style="text-decoration:none; padding:5px 10px; background:#fff; border:1px solid #ddd; border-radius:3px; font-size:12px; color:#333;">«</a>'; }
            for($i=1; $i<=$total_pages; $i++) {
                $style = ($i == $current_page) ? 'background:#007bff; color:#fff; border-color:#007bff;' : 'background:#fff; color:#333; border-color:#ddd;';
                echo '<a href="'.esc_url(add_query_arg('blyx_p', $i, $base_url)).'" style="text-decoration:none; padding:5px 10px; border:1px solid; border-radius:3px; font-size:12px; '.esc_attr($style).'">'.esc_html($i).'</a>';
            }
            if($current_page < $total_pages) { echo '<a href="'.esc_url(add_query_arg('blyx_p', $current_page+1, $base_url)).'" style="text-decoration:none; padding:5px 10px; background:#fff; border:1px solid #ddd; border-radius:3px; font-size:12px; color:#333;">»</a>'; }
            ?>
        </div>
        <?php endif; ?>
    </div>
    <?php
    if($return) return ob_get_clean();
}

// =================================================================
// BÖLÜM 2: API ANAHTARLARI
// =================================================================
add_action('um_after_account_general', 'blyxxa_api_form_localized', 5);
function blyxxa_api_form_localized($return = false) {
    if (!is_user_logged_in()) return;
    $user_id = get_current_user_id();
    $text_domain = 'blyxxa-core';
    $msg = "";
    if (isset($_POST['blyxxa_save_keys']) && wp_verify_nonce($_POST['blyx_nonce'], 'save_keys')) {
        if(isset($_POST['gemini_key'])) update_user_meta($user_id, 'blyxxa_gemini_key', sanitize_text_field(wp_unslash($_POST['gemini_key'])));
        if(isset($_POST['openai_key'])) update_user_meta($user_id, 'blyxxa_openai_key', sanitize_text_field(wp_unslash($_POST['openai_key'])));
        if(isset($_POST['perplexity_key'])) update_user_meta($user_id, 'blyxxa_perplexity_key', sanitize_text_field(wp_unslash($_POST['perplexity_key'])));
        if(isset($_POST['anthropic_key'])) update_user_meta($user_id, 'blyxxa_anthropic_key', sanitize_text_field(wp_unslash($_POST['anthropic_key'])));
        if(isset($_POST['openrouter_key'])) update_user_meta($user_id, 'blyxxa_openrouter_key', sanitize_text_field(wp_unslash($_POST['openrouter_key'])));
        if(isset($_POST['blyxxa_groq_key'])) update_user_meta($user_id, 'blyxxa_groq_key', sanitize_text_field(wp_unslash($_POST['blyxxa_groq_key'])));
    $msg = '<div style="background:#d1e7dd; color:#0f5132; padding:15px; margin-bottom:20px; border-radius:8px; border:1px solid #badbcc; font-weight:600; font-size:14px;">✅ '.esc_html__('Settings saved successfully!', 'blyxxa-core').'</div>';
    }
    $gemini = get_user_meta($user_id, 'blyxxa_gemini_key', true);
    $openai = get_user_meta($user_id, 'blyxxa_openai_key', true);
    $perplexity = get_user_meta($user_id, 'blyxxa_perplexity_key', true);
    $anthropic = get_user_meta($user_id, 'blyxxa_anthropic_key', true);
    $openrouter = get_user_meta($user_id, 'blyxxa_openrouter_key', true);
    $groq = get_user_meta($user_id, 'blyxxa_groq_key', true);
    
    if($return) ob_start();
    ?>
    <style>
        .blyxxa-api-card { width: 100%; margin: 30px 0; background: #fff; padding: 30px; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.04); border: 1px solid #eee; font-family: inherit; box-sizing: border-box; }
        .blyx-input:focus { border-color: #3ba1da; outline: none; box-shadow: 0 0 0 2px rgba(59,161,218,0.1); }
        .blyx-btn-save { background: #3ba1da; color: #fff; border: none; padding: 12px 25px; border-radius: 4px; font-size: 14px; cursor: pointer; font-weight: bold; transition:0.2s; }
        .blyx-btn-save:hover { background: #3391c6; transform:translateY(-1px); }
    </style>
    <div class="blyxxa-api-card">
        <h3 style="margin:0 0 10px 0; font-size:18px; font-weight:bold; color:#333; border-bottom:1px solid #f0f0f0; padding-bottom:15px;">🚀 <?php echo esc_html__('AI Engine Settings (BYOK)', 'blyxxa-core'); ?></h3>
        <?php echo wp_kses_post($msg); ?>
        <p style="color:#666; font-size:13px; margin-bottom:25px; line-height:1.5;"><?php echo esc_html__('Enter your own API keys here to use Blyxxa Labs tools. Your keys are stored encrypted and used only during execution.', 'blyxxa-core'); ?></p>
        <form method="post" action="">
            <div style="margin-bottom:20px;">
                <label style="font-weight:600; display:block; margin-bottom:8px; color:#444; font-size:14px;"><?php esc_html_e('Google Gemini API Key', 'blyxxa-core'); ?></label>
                <input type="password" name="gemini_key" value="<?php echo esc_attr($gemini); ?>" style="width:100%; padding:10px 12px; border:1px solid #ddd; border-radius:4px; font-size:14px;" placeholder="AIzaSy...">
                <div style="font-size:12px; color:#888; margin-top:5px;">👉 <?php echo esc_html__('Get free key:', 'blyxxa-core'); ?> <a href="https://aistudio.google.com/app/apikey" target="_blank" style="color:#3ba1da; text-decoration:none;">Google AI Studio</a></div>
            </div>
            <div style="margin-bottom:20px;">
                <label style="font-weight:600; display:block; margin-bottom:8px; color:#444; font-size:14px;"><?php esc_html_e('OpenAI (ChatGPT) API Key', 'blyxxa-core'); ?></label>
                <input type="password" name="openai_key" value="<?php echo esc_attr($openai); ?>" style="width:100%; padding:10px 12px; border:1px solid #ddd; border-radius:4px; font-size:14px;" placeholder="sk-proj-...">
                <div style="font-size:12px; color:#888; margin-top:5px;">👉 <?php echo esc_html__('Get key:', 'blyxxa-core'); ?> <a href="https://platform.openai.com/api-keys" target="_blank" style="color:#3ba1da; text-decoration:none;">OpenAI Dashboard</a></div>
            </div>
            <div style="margin-bottom:20px;">
                <label style="font-weight:600; display:block; margin-bottom:8px; color:#444; font-size:14px;"><?php esc_html_e('Perplexity API Key', 'blyxxa-core'); ?></label>
                <input type="password" name="perplexity_key" value="<?php echo esc_attr($perplexity); ?>" style="width:100%; padding:10px 12px; border:1px solid #ddd; border-radius:4px; font-size:14px;" placeholder="pplx-...">
                <div style="font-size:12px; color:#888; margin-top:5px;">👉 <?php echo esc_html__('Get key:', 'blyxxa-core'); ?> <a href="https://www.perplexity.ai/settings/api" target="_blank" style="color:#3ba1da; text-decoration:none;">Perplexity Settings</a></div>
            </div>
            <div style="margin-bottom:20px;">
                <label style="font-weight:600; display:block; margin-bottom:8px; color:#444; font-size:14px;"><?php esc_html_e('Anthropic (Claude) API Key', 'blyxxa-core'); ?></label>
                <input type="password" name="anthropic_key" value="<?php echo esc_attr($anthropic); ?>" style="width:100%; padding:10px 12px; border:1px solid #ddd; border-radius:4px; font-size:14px;" placeholder="sk-ant-...">
                <div style="font-size:12px; color:#888; margin-top:5px;">👉 <?php echo esc_html__('Get key:', 'blyxxa-core'); ?> <a href="https://console.anthropic.com/settings/keys" target="_blank" style="color:#3ba1da; text-decoration:none;">Anthropic Console</a></div>
            </div>
            <div style="margin-bottom:20px;">
                <label style="font-weight:600; display:block; margin-bottom:8px; color:#444; font-size:14px;"><?php esc_html_e('OpenRouter API Key', 'blyxxa-core'); ?></label>
                <input type="password" name="openrouter_key" value="<?php echo esc_attr($openrouter); ?>" style="width:100%; padding:10px 12px; border:1px solid #ddd; border-radius:4px; font-size:14px;" placeholder="sk-or-...">
                <div style="font-size:12px; color:#888; margin-top:5px;">👉 <?php echo esc_html__('Get key:', 'blyxxa-core'); ?> <a href="https://openrouter.ai/keys" target="_blank" style="color:#3ba1da; text-decoration:none;">OpenRouter Keys</a></div>
            </div>
            <div style="margin-bottom:20px;">
                <label style="font-weight:600; display:block; margin-bottom:8px; color:#444; font-size:14px;"><?php esc_html_e('Groq API Key', 'blyxxa-core'); ?></label>
                <input type="password" name="blyxxa_groq_key" value="<?php echo esc_attr($groq); ?>" style="width:100%; padding:10px 12px; border:1px solid #ddd; border-radius:4px; font-size:14px;" placeholder="gsk_...">
                <div style="font-size:12px; color:#888; margin-top:5px;">👉 <?php echo esc_html__('Get key:', 'blyxxa-core'); ?> <a href="https://console.groq.com/keys" target="_blank" style="color:#3ba1da; text-decoration:none;">Groq Console</a></div>

            </div>
        
        <hr style="margin:30px 0; border:0; border-top:1px solid #eee;">
        
        <hr style="margin:30px 0; border:0; border-top:1px solid #eee;">
            <?php wp_nonce_field('save_keys', 'blyx_nonce'); ?>
            <div style="text-align:right; margin-top:10px;">
                <button type="submit" name="blyxxa_save_keys" class="blyx-btn-save"><?php echo esc_html__('Save Settings', 'blyxxa-core'); ?></button>
            </div>
        </form>
    </div>
    <?php
    if($return) return ob_get_clean();
}

// =================================================================
// BÖLÜM 3: LİSANS DURUMU (TEST PROTOCOL EDITION)
// =================================================================
add_action('um_after_account_general', 'blyxxa_status_localized', 10);
function blyxxa_status_localized($return = false) {
    
    $target_product_id = get_option('blyxxa_gumroad_product_id'); 
    $user = wp_get_current_user();
    $user_email = trim($user->user_email);
    $text_domain = 'blyxxa-core';
    $msg = "";

    if($return) ob_start();

    $roles = (array) $user->roles;
    $is_premium = in_array('blyxxa_premium', $roles) || in_array('blyxxa_corporate', $roles) || in_array('administrator', $roles);

    if (isset($_POST['blyxxa_auto_verify']) && wp_verify_nonce($_POST['blyx_verify_nonce'], 'verify_order')) {
        
        // GUMROAD API CHECK
        $gumroad_token = get_option('blyxxa_gumroad_token');
        $gumroad_product_id = get_option('blyxxa_gumroad_product_id');

        if(empty($gumroad_token) || empty($gumroad_product_id)) {
             $msg = "<div class='um-field-error'>❌ " . esc_html__('Configuration Error: Missing Gumroad API Keys.', 'blyxxa-core') . "</div>";
        } else {
            // 1. Resolve Product ID (Smart Lookup)
            $resolved_id = $gumroad_product_id;
            
            // If ID doesn't look like a UUID (starts with 's' usually, but let's be safe), try to lookup
            // Or just always lookup to be safe if it's not working
            $products_url = "https://api.gumroad.com/v2/products?access_token=" . $gumroad_token;
            $prod_response = wp_remote_get($products_url, array('timeout' => 20, 'sslverify' => false));
            
            if (!is_wp_error($prod_response)) {
                $prod_body = wp_remote_retrieve_body($prod_response);
                $prod_json = json_decode($prod_body, true);
                if (!empty($prod_json['products'])) {
                    foreach ($prod_json['products'] as $p) {
                        // Check ID, Permalink, or Custom Permalink
                        if ( (isset($p['id']) && $p['id'] === $gumroad_product_id) || 
                             (isset($p['permalink']) && $p['permalink'] === $gumroad_product_id) || 
                             (isset($p['custom_permalink']) && $p['custom_permalink'] === $gumroad_product_id) ) {
                            $resolved_id = $p['id'];
                            break;
                        }
                    }
                }
            }

            $api_url = "https://api.gumroad.com/v2/products/$resolved_id/subscribers?email=" . urlencode($user_email) . "&access_token=" . $gumroad_token;
            
            $response = wp_remote_get($api_url, array('timeout' => 20, 'sslverify' => false));
            
            if (is_wp_error($response)) {
                $err = $response->get_error_message();
                $msg = "<div class='um-field-error'>❌ " . sprintf(esc_html__('Connection Error: %s', 'blyxxa-core'), esc_html($err)) . "</div>";
            } else {
                $body = wp_remote_retrieve_body($response);
                $json = json_decode($body, true);
                
                $subscribers = $json['subscribers'] ?? [];
                $is_valid = false;

                if(!empty($subscribers)) {
                    foreach($subscribers as $sub) {
                        if($sub['status'] === 'alive') {
                            $is_valid = true;
                            break;
                        }
                    }
                }

                if ($is_valid) {
                    $user->add_role('blyxxa_corporate'); // Assign corporate role
                    $is_premium = true; // Update local variable immediately
                    
                    // Save dates
                    if(isset($sub['created_at'])) {
                        update_user_meta($user->ID, 'blyxxa_sub_start', $sub['created_at']);
                    }
                    
                    $msg = "<div class='um-field-notice success'>🎉 ".esc_html__('SUBSCRIPTION VERIFIED!', 'blyxxa-core')."</div>";
                } else {
                    $msg = "<div class='um-field-error'>❌ ".esc_html__('No active subscription found for this email.', 'blyxxa-core')."</div>";
                    // Downgrade if not valid
                    if($is_premium) $user->remove_role('blyxxa_premium');
                }
            }
        }
    }

    $status_label = $is_premium ? esc_html__('Premium Member', 'blyxxa-core') : esc_html__('Free Member', 'blyxxa-core');
    $status_badge = $is_premium ? esc_html__('ACTIVE', 'blyxxa-core') : esc_html__('UPGRADE', 'blyxxa-core');
    $license_title = esc_html__('LICENSE STATUS', 'blyxxa-core');
    ?>
    <div class="um-field" style="margin-top: 0px; padding-top: 20px; border-top: 2px dashed #eee;">
        <?php echo wp_kses_post($msg); ?>
        <div style="display: flex; align-items: center; justify-content: space-between; background: #f9f9f9; padding: 15px; border-radius: 5px; border:1px solid #eee;">
            <div>
                <small style="display:block; color:#999; text-transform:uppercase; font-size:10px; font-weight:bold;"><?php echo esc_html($license_title); ?></small>
                <div style="display:flex; align-items:center; gap:8px; margin-top: 5px;">
                    <span style="font-size: 18px;"><?php echo $is_premium ? '🌟' : '👤'; ?></span>
                    <strong style="font-size:14px; color:#555;"><?php echo esc_html($status_label); ?></strong>
                </div>
            </div>
            <?php if(!$is_premium): ?>
                <form method="post" style="margin:0;">
                    <?php wp_nonce_field('verify_order', 'blyx_verify_nonce'); ?>
                    <button type="submit" name="blyxxa_auto_verify" style="background: #e0e0e0; color: #333; border: 1px solid #ccc; padding: 6px 12px; border-radius: 4px; font-size: 12px; cursor: pointer; font-weight: bold;">
                        🔄 <?php echo esc_html__('Check License', 'blyxxa-core'); ?>
                    </button>
                </form>
            <?php else: ?>
                 <div style="color:#28a745; font-size:11px; font-weight:bold; background:#d4edda; padding:3px 8px; border-radius:3px;"><?php echo esc_html($status_badge); ?></div>
            <?php endif; ?>
        </div>
        
        <?php 
        $sub_start = get_user_meta($user->ID, 'blyxxa_sub_start', true);
        if($is_premium && $sub_start): 
            $date_formatted = date_i18n(get_option('date_format'), strtotime($sub_start));
        ?>
            <div style="margin-top:5px; font-size:11px; color:#666; padding-left:5px;">
                📅 <?php esc_html_e('Member Since:', 'blyxxa-core'); ?> <strong><?php echo esc_html($date_formatted); ?></strong>
            </div>
        <?php endif; ?>

        <!-- Subscription Management Block -->
        <?php if($is_premium): ?>
        <div style="margin-top: 20px; background: #fff; border: 1px solid #e2e8f0; border-radius: 5px; padding: 15px;">
            <h4 style="margin:0 0 10px 0; font-size:12px; color:#475569; border-bottom:1px solid #f1f5f9; padding-bottom:5px;">
                ⚙️ <?php esc_html_e('Subscription Management', 'blyxxa-core'); ?>
            </h4>
            
            <div style="font-size:11px; color:#64748b; margin-bottom:10px;">
                ℹ️ <?php echo esc_html__('License verification is handled by Gumroad.', 'blyxxa-core'); ?>
            </div>

            <a href="https://gumroad.com/library" target="_blank" style="display:inline-block; background:#fff; color:#dc2626; border:1px solid #dc2626; padding:5px 10px; border-radius:4px; font-size:11px; text-decoration:none; font-weight:600;">
                🚫 <?php esc_html_e('Cancel Subscription', 'blyxxa-core'); ?>
            </a>
            
            <div style="margin-top:10px; font-size:10px; color:#ef4444; background:#fef2f2; padding:8px; border-radius:4px; border:1px solid #fee2e2;">
                ⚠️ <?php esc_html_e('Deleting your account DOES NOT cancel your subscription. You must cancel via Gumroad.', 'blyxxa-core'); ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php
    if($return) return ob_get_clean();
}

// SHORTCODE
add_shortcode('blyxxa_api_form', function() {
    if (!is_user_logged_in()) return esc_html__('Please log in.', 'blyxxa-core');
    $user_id = get_current_user_id();
    if (isset($_POST['blyxxa_save_keys']) && wp_verify_nonce($_POST['blyx_nonce'], 'save_keys')) {
        if(isset($_POST['gemini_key'])) update_user_meta($user_id, 'blyxxa_gemini_key', sanitize_text_field($_POST['gemini_key']));
        if(isset($_POST['openai_key'])) update_user_meta($user_id, 'blyxxa_openai_key', sanitize_text_field($_POST['openai_key']));
        if(isset($_POST['perplexity_key'])) update_user_meta($user_id, 'blyxxa_perplexity_key', sanitize_text_field($_POST['perplexity_key']));
        if(isset($_POST['anthropic_key'])) update_user_meta($user_id, 'blyxxa_anthropic_key', sanitize_text_field($_POST['anthropic_key']));
        if(isset($_POST['openrouter_key'])) update_user_meta($user_id, 'blyxxa_openrouter_key', sanitize_text_field($_POST['openrouter_key']));
        echo '<div style="color:green; margin-bottom:10px;">✅ '.esc_html__('Settings saved successfully!', 'blyxxa-core').'</div>';
    }
    $gemini = get_user_meta($user_id, 'blyxxa_gemini_key', true);
    $openai = get_user_meta($user_id, 'blyxxa_openai_key', true);
    ob_start();
    ?>
    <form method="post" style="background:#f9f9f9; padding:20px; border-radius:8px; border:1px solid #ddd;">
        <h3>🔑 <?php esc_html_e('AI Engine Settings (BYOK)', 'blyxxa-core'); ?></h3>
        <p><small><?php esc_html_e('Enter your own API keys here to use Blyxxa Labs tools. Your keys are stored encrypted and used only during execution.', 'blyxxa-core'); ?></small></p>
        <label><strong><?php esc_html_e('Google Gemini API Key:', 'blyxxa-core'); ?></strong></label>
        <input type="password" name="gemini_key" value="<?php echo esc_attr($gemini); ?>" style="width:100%; margin-bottom:10px; padding:8px;">
        
        <label><strong><?php esc_html_e('OpenAI API Key (Optional):', 'blyxxa-core'); ?></strong></label>
        <input type="password" name="openai_key" value="<?php echo esc_attr($openai); ?>" style="width:100%; margin-bottom:10px; padding:8px;">

        <label><strong><?php esc_html_e('Perplexity API Key:', 'blyxxa-core'); ?></strong></label>
        <input type="password" name="perplexity_key" value="<?php echo esc_attr(get_user_meta($user_id, 'blyxxa_perplexity_key', true)); ?>" style="width:100%; margin-bottom:10px; padding:8px;">

        <label><strong><?php esc_html_e('Anthropic (Claude) API Key:', 'blyxxa-core'); ?></strong></label>
        <input type="password" name="anthropic_key" value="<?php echo esc_attr(get_user_meta($user_id, 'blyxxa_anthropic_key', true)); ?>" style="width:100%; margin-bottom:10px; padding:8px;">

        <label><strong><?php esc_html_e('OpenRouter API Key:', 'blyxxa-core'); ?></strong></label>
        <input type="password" name="openrouter_key" value="<?php echo esc_attr(get_user_meta($user_id, 'blyxxa_openrouter_key', true)); ?>" style="width:100%; margin-bottom:10px; padding:8px;">
        <?php wp_nonce_field('save_keys', 'blyx_nonce'); ?>
        <button type="submit" name="blyxxa_save_keys" style="background:#333; color:#fff; padding:10px 20px; border:none; cursor:pointer;"><?php esc_html_e('Save Settings', 'blyxxa-core'); ?></button>
    </form>
    <?php
    return ob_get_clean();
});

// =================================================================
// BÖLÜM 4: HESAP YÖNETİMİ (NATIVE)
// =================================================================

// 1. PROFİL DÜZENLEME [blyxxa_profile]
add_shortcode('blyxxa_profile', function() {
    if (!is_user_logged_in()) return '<p>'.esc_html__('Please log in to edit your profile.', 'blyxxa-core').'</p>';
    
    $user = wp_get_current_user();
    $msg = '';
    
    if (isset($_POST['blyxxa_update_profile']) && wp_verify_nonce($_POST['blyx_profile_nonce'], 'update_profile')) {
        $errors = [];
        
        // Update Name
        if (!empty($_POST['first_name'])) update_user_meta($user->ID, 'first_name', sanitize_text_field($_POST['first_name']));
        if (!empty($_POST['last_name'])) update_user_meta($user->ID, 'last_name', sanitize_text_field($_POST['last_name']));
        
        // Update Email
        if (!empty($_POST['email']) && $_POST['email'] !== $user->user_email) {
            if (email_exists($_POST['email'])) {
                $errors[] = esc_html__('Email already in use.', 'blyxxa-core');
            } else {
                wp_update_user(['ID' => $user->ID, 'user_email' => sanitize_email($_POST['email'])]);
            }
        }
        
        // Update Password
        if (!empty($_POST['pass1']) && !empty($_POST['pass2'])) {
            if ($_POST['pass1'] === $_POST['pass2']) {
                wp_update_user(['ID' => $user->ID, 'user_pass' => $_POST['pass1']]);
            } else {
                $errors[] = esc_html__('Passwords do not match.', 'blyxxa-core');
            }
        }
        
        if (empty($errors)) {
            $msg = '<div style="color:green; margin-bottom:10px;">✅ '.esc_html__('Profile updated successfully!', 'blyxxa-core').'</div>';
            $user = wp_get_current_user(); // Refresh user data
        } else {
            $msg = '<div style="color:red; margin-bottom:10px;">❌ ' . implode('<br>', $errors) . '</div>';
        }
    }
    
    // Enqueue Gumroad Script
    add_action('wp_enqueue_scripts', function() {
        wp_enqueue_script('blyxxa-gumroad', 'https://gumroad.com/js/gumroad.js', [], '1.0', true);
    });

    ob_start();
    ?>
    <div class="blyxxa-profile-wrap" style="max-width:500px; margin:20px auto; padding:20px; background:#fff; border:1px solid #eee; border-radius:8px;">
        <h3 style="margin-top:0;">👤 <?php esc_html_e('Edit Profile', 'blyxxa-core'); ?></h3>
        <?php echo wp_kses_post($msg); ?>
        <form method="post">
            <div style="margin-bottom:15px;">
                <label style="display:block; font-weight:bold;"><?php esc_html_e('First Name', 'blyxxa-core'); ?></label>
                <input type="text" name="first_name" value="<?php echo esc_attr($user->first_name); ?>" style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px;">
            </div>
            <div style="margin-bottom:15px;">
                <label style="display:block; font-weight:bold;"><?php esc_html_e('Last Name', 'blyxxa-core'); ?></label>
                <input type="text" name="last_name" value="<?php echo esc_attr($user->last_name); ?>" style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px;">
            </div>
            <div style="margin-bottom:15px;">
                <label style="display:block; font-weight:bold;"><?php esc_html_e('Email', 'blyxxa-core'); ?></label>
                <input type="email" name="email" value="<?php echo esc_attr($user->user_email); ?>" style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px;">
            </div>
            
            <hr style="margin:20px 0; border:0; border-top:1px solid #eee;">
            <h4 style="margin-bottom:10px;"><?php esc_html_e('Change Password (Optional)', 'blyxxa-core'); ?></h4>
            
            <div style="margin-bottom:15px;">
                <label style="display:block; font-weight:bold;"><?php esc_html_e('New Password', 'blyxxa-core'); ?></label>
                <input type="password" name="pass1" style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px;">
            </div>
            <div style="margin-bottom:15px;">
                <label style="display:block; font-weight:bold;"><?php esc_html_e('Confirm Password', 'blyxxa-core'); ?></label>
                <input type="password" name="pass2" style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px;">
            </div>
            
            <?php wp_nonce_field('update_profile', 'blyx_profile_nonce'); ?>
            <button type="submit" name="blyxxa_update_profile" style="background:#007bff; color:#fff; padding:10px 20px; border:none; border-radius:4px; cursor:pointer; font-weight:bold;"><?php esc_html_e('Update Profile', 'blyxxa-core'); ?></button>
        </form>
        
        <div style="margin-top:30px; padding:15px; background:#fff5f5; border:1px solid #fed7d7; border-radius:6px; color:#c53030; font-size:13px;">
            <strong>⚠️ <?php esc_html_e('IMPORTANT:', 'blyxxa-core'); ?></strong> 
            <?php esc_html_e('Deleting your account here DOES NOT cancel your subscription on Gumroad. Please cancel your subscription on Gumroad first to avoid future charges.', 'blyxxa-core'); ?>
        </div>

        <div style="margin-top:20px; text-align:right;">
             <a href="https://gumroad.com/library" target="_blank" style="color:#c53030; text-decoration:underline; font-size:13px; margin-right:15px;"><?php esc_html_e('Cancel Subscription (Gumroad)', 'blyxxa-core'); ?></a>
             
             <form method="post" style="display:inline;" onsubmit="return confirm('<?php echo esc_js(__('Are you sure you want to permanently delete your account? This cannot be undone.', 'blyxxa-core')); ?>');">
                <?php wp_nonce_field('delete_account', 'blyx_delete_nonce'); ?>
                <button type="submit" name="blyxxa_delete_account" style="background:none; border:none; color:#c53030; cursor:pointer; font-size:13px; text-decoration:underline;"><?php esc_html_e('Delete Account', 'blyxxa-core'); ?></button>
             </form>
        </div>
    </div>
    <?php
    return ob_get_clean();
});

// Handle Account Deletion Logic (Hook into init to process before headers)
add_action('init', function() {
    if (isset($_POST['blyxxa_delete_account']) && is_user_logged_in()) {
        if (wp_verify_nonce($_POST['blyx_delete_nonce'], 'delete_account')) {
            require_once(ABSPATH . 'wp-admin/includes/user.php');
            $current_user = wp_get_current_user();
            wp_delete_user($current_user->ID);
            wp_safe_redirect(home_url());
            exit;
        }
    }
});

// 2. ŞİFREMİ UNUTTUM [blyxxa_forgot_password]
add_shortcode('blyxxa_forgot_password', function() {
    if (is_user_logged_in()) return '<p>'.esc_html__('You are already logged in.', 'blyxxa-core').'</p>';
    
    $msg = '';
    if (isset($_POST['blyxxa_reset_request']) && wp_verify_nonce($_POST['blyx_reset_nonce'], 'reset_request')) {
        $email = sanitize_email($_POST['user_login']);
        $user = get_user_by('email', $email);
        if (!$user) $user = get_user_by('login', $email);
        
        if ($user) {
            $key = get_password_reset_key($user);
            if (!is_wp_error($key)) {
                $reset_url = site_url("wp-login.php?action=rp&key=$key&login=" . rawurlencode($user->user_login));
                $message = __('Someone has requested a password reset for the following account:', 'blyxxa-core') . "\r\n\r\n";
                $message .= site_url() . "\r\n\r\n";
                $message .= __('Username:', 'blyxxa-core') . sprintf(' %s', $user->user_login) . "\r\n\r\n";
                $message .= __('If this was a mistake, just ignore this email and nothing will happen.', 'blyxxa-core') . "\r\n\r\n";
                $message .= __('To reset your password, visit the following address:', 'blyxxa-core') . "\r\n\r\n";
                $message .= $reset_url . "\r\n";
                
                wp_mail($user->user_email, __('Password Reset Request', 'blyxxa-core'), $message);
                $msg = '<div style="color:green; margin-bottom:10px;">✅ '.esc_html__('Check your email for the confirmation link.', 'blyxxa-core').'</div>';
            } else {
                $msg = '<div style="color:red;">❌ '.esc_html__('System error. Please try again.', 'blyxxa-core').'</div>';
            }
        } else {
            $msg = '<div style="color:red;">❌ '.esc_html__('User not found.', 'blyxxa-core').'</div>';
        }
    }
    
    ob_start();
    ?>
    <div style="max-width:400px; margin:20px auto; padding:20px; background:#fff; border:1px solid #eee; border-radius:8px;">
        <h3 style="margin-top:0;">🔒 <?php esc_html_e('Reset Password', 'blyxxa-core'); ?></h3>
        <?php echo wp_kses_post($msg); ?>
        <form method="post">
            <div style="margin-bottom:15px;">
                <label style="display:block; font-weight:bold;"><?php esc_html_e('Username or Email', 'blyxxa-core'); ?></label>
                <input type="text" name="user_login" style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px;" required>
            </div>
            <?php wp_nonce_field('reset_request', 'blyx_reset_nonce'); ?>
            <button type="submit" name="blyxxa_reset_request" style="background:#333; color:#fff; padding:10px 20px; border:none; border-radius:4px; cursor:pointer;"><?php esc_html_e('Get New Password', 'blyxxa-core'); ?></button>
        </form>
    </div>
    <?php
    return ob_get_clean();
});

// =================================================================
// BÖLÜM 5: AJAX HANDLERS
// =================================================================
add_action('wp_ajax_blyxxa_save_result', 'blyxxa_save_result_handler');
function blyxxa_save_result_handler() {
    check_ajax_referer('blyxxa_tool_nonce', 'nonce');
    
    if (!is_user_logged_in()) {
        wp_send_json_error(__('You must be logged in to save results.', 'blyxxa-core'));
    }

    $user_id = get_current_user_id();
    $tool_id = sanitize_text_field($_POST['tool_id']);
    $content = wp_kses_post($_POST['content']); // Allow HTML for formatting
    
    // Get existing history
    $history = get_user_meta($user_id, 'blyxxa_history', true);
    if (!is_array($history)) $history = [];
    
    // Create new entry
    $new_entry = [
        'id' => uniqid('h_'),
        'tool_id' => $tool_id,
        'title' => ucfirst(str_replace('_', ' ', $tool_id)) . ' - ' . date_i18n(get_option('date_format') . ' ' . get_option('time_format')),
        'content' => $content,
        'date' => date_i18n(get_option('date_format')),
        'timestamp' => current_time('timestamp')
    ];
    
    // Prepend to history (newest first)
    array_unshift($history, $new_entry);
    
    // Limit history size (optional, e.g., keep last 50)
    $history = array_slice($history, 0, 50);
    
    update_user_meta($user_id, 'blyxxa_history', $history);
    
    wp_send_json_success(['msg' => __('Saved successfully!', 'blyxxa-core')]);
}