<?php
// BLYXXA TOOL MANAGER (MODULAR FILE SYSTEM) - CLIENT VERSION

function blyxxa_tool_manager_page() {
    // Klasör Kontrolü
    if (!is_dir(BLYXXA_TOOLS_PATH)) {
        wp_mkdir_p(BLYXXA_TOOLS_PATH);
    }
    
    $msg = '';

    // =========================================================
    // 1. ACTION: TOGGLE STATUS (Synchronous / No-JS fallback)
    // =========================================================
    if ( isset($_GET['toggle_status']) && check_admin_referer('blyx_status_toggle') ) {
        if(!current_user_can('manage_options')) wp_die('Unauthorized');

        $slug = sanitize_text_field(wp_unslash($_GET['toggle_status']));
        $lib = get_option('blyxxa_tool_library', []);
        
        // Self-Healing: Ensure entry exists
        if(!isset($lib[$slug]) && file_exists(BLYXXA_TOOLS_PATH . $slug . '.php')) {
            $lib[$slug] = ['status' => 'draft', 'version' => '1.0'];
        }

        if(isset($lib[$slug])) {
            $current = isset($lib[$slug]['status']) ? $lib[$slug]['status'] : 'draft';
            $new_status = ($current === 'published') ? 'draft' : 'published';
            $lib[$slug]['status'] = $new_status;
            update_option('blyxxa_tool_library', $lib);
            
            // Redirect to avoid re-submission
            $redirect_url = remove_query_arg(['toggle_status', '_wpnonce']);
            echo '<script>window.location.href="'.$redirect_url.'";</script>'; 
            exit;
        }
    }

    // Dosya Silme
    if ( isset($_GET['del']) && check_admin_referer('del_tool') ) {
        $file_to_del = BLYXXA_TOOLS_PATH . sanitize_file_name(wp_unslash($_GET['del']));
        if ( file_exists($file_to_del) ) {
            wp_delete_file($file_to_del);
            
            // SYNC: Remove from Library
            $slug = str_replace('.php', '', sanitize_file_name(wp_unslash($_GET['del'])));
            $lib = get_option('blyxxa_tool_library', []);
            if(isset($lib[$slug])) {
                unset($lib[$slug]);
                update_option('blyxxa_tool_library', $lib);
            }

            $msg = '<div class="notice notice-warning is-dismissible"><p>🗑️ ' . esc_html__('Tool deleted.', 'blyxxa-core') . '</p></div>';
        }
    }
    
    // Kategori Değiştirme
    if ( isset($_POST['blyxxa_update_cat']) && check_admin_referer('blyx_tool_act') ) {
        $file = BLYXXA_TOOLS_PATH . (isset($_POST['filename']) ? sanitize_file_name(wp_unslash($_POST['filename'])) : '');
        $new_cat = isset($_POST['new_cat']) ? sanitize_text_field(wp_unslash($_POST['new_cat'])) : 'General';
        
        if ( file_exists($file) ) {
            $content = file_get_contents($file);
            // Regex to find "Category: OldName" or add it if missing
            $pattern = '/(\*\s*Category:\s*)(.*)(\s*[\r\n])/i';
            if(preg_match($pattern, $content)) {
                $new_content = preg_replace($pattern, '${1}' . $new_cat . '${3}', $content);
            } else {
                // Insert after ID if no category exists
                $new_content = preg_replace('/(\*\s*ID:.*[\r\n])/', '$1 * Category: '.$new_cat."\n", $content);
            }
            file_put_contents($file, $new_content);
            $msg = '<div class="notice notice-success is-dismissible"><p>✅ ' . esc_html__('Category updated!', 'blyxxa-core') . '</p></div>';
        }
    }

    // 2. MEVCUT DOSYALARI LİSTELE
    $all_files = glob( BLYXXA_TOOLS_PATH . '*.php' );
    $library_data = get_option('blyxxa_tool_library', []);
    
    // SERVER-SIDE SEARCH & FILTER
    $search_query = isset($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';
    $filter_type  = isset($_GET['type']) ? sanitize_text_field(wp_unslash($_GET['type'])) : '';

    if($search_query || $filter_type) {
        $all_files = array_filter($all_files, function($file) use ($search_query, $filter_type) {
            $is_match = true;
            $content = file_get_contents($file);
            
            // 1. Search Query
            if($search_query) {
                $basename = basename($file);
                // Search in filename and content (Category, ID, Title)
                if (stripos($basename, $search_query) === false && stripos($content, $search_query) === false) {
                    $is_match = false;
                }
            }

            // 2. Type Filter
            if($is_match && $filter_type) {
                $file_data = get_file_data($file, ['Role' => 'Role']);
                $role_raw = !empty($file_data['Role']) ? strtolower(trim($file_data['Role'])) : 'member';
                $free_roles = ['member', 'read', 'subscriber', ''];
                $is_free = in_array($role_raw, $free_roles);

                if ($filter_type === 'free' && !$is_free) {
                    $is_match = false;
                } elseif ($filter_type === 'premium' && $is_free) {
                    $is_match = false;
                }
            }

            return $is_match;
        });
    }

    $total_files = count($all_files);
    $per_page = 12; // Grid view needs more items
    $current_page = isset($_GET['p']) ? max(1, intval($_GET['p'])) : 1;
    $total_pages = ceil($total_files / $per_page);
    $offset = ($current_page - 1) * $per_page;
    $files = array_slice($all_files, $offset, $per_page);
    ?>
    
    <div class="wrap" style="font-family:'Inter', sans-serif; max-width:1200px; margin: 20px auto;">
        
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom: 20px; background:#fff; padding:20px; border-radius:12px; border:1px solid #e2e8f0; box-shadow:0 4px 6px rgba(0,0,0,0.02);">
            <div>
                <h1 style="margin:0; font-size:24px; color:#1e293b; display:flex; align-items:center; gap:10px;">
                    <span class="dashicons dashicons-admin-tools" style="font-size:32px; width:32px; height:32px; color:#0ea5e9;"></span>
                    Blyxxa Tool Manager
                </h1>
                <p style="margin:5px 0 0 0; color:#64748b; font-size:14px;"><?php esc_html_e('Manage your AI tools and generators.', 'blyxxa-core'); ?></p>
            </div>
            
            <form method="get" style="display:flex; gap:10px; align-items:center;">
                <input type="hidden" name="page" value="blyxxa-tool-manager">
                
                <select name="type" style="padding:8px 30px 8px 10px; border:1px solid #cbd5e1; border-radius:8px; font-size:14px; outline:none; cursor:pointer; height:42px;">
                    <option value="" <?php selected($filter_type, ''); ?>><?php esc_html_e('All Types', 'blyxxa-core'); ?></option>
                    <option value="free" <?php selected($filter_type, 'free'); ?>><?php esc_html_e('Free Tools', 'blyxxa-core'); ?></option>
                    <option value="premium" <?php selected($filter_type, 'premium'); ?>><?php esc_html_e('Premium Tools', 'blyxxa-core'); ?></option>
                </select>

                <div style="position:relative;">
                    <span class="dashicons dashicons-search" style="position:absolute; left:10px; top:50%; transform:translateY(-50%); color:#94a3b8;"></span>
                    <input type="text" name="s" value="<?php echo esc_attr($search_query); ?>" placeholder="<?php esc_attr_e('Search tools...', 'blyxxa-core'); ?>" style="padding:10px 10px 10px 35px; border:1px solid #cbd5e1; border-radius:8px; font-size:14px; width:200px; outline:none; transition:border 0.2s; height:42px;" onfocus="this.style.borderColor='#0ea5e9'">
                </div>
                <button type="submit" class="button button-primary" style="background:#0f172a; border-color:#0f172a; padding: 0 20px; height:42px; line-height:42px; font-size:14px;"><?php esc_html_e('Filter', 'blyxxa-core'); ?></button>
            </form>
        </div>
        
        <?php echo wp_kses_post($msg); ?>

        <?php if ( empty($files) ) : ?>
            <div style="background:#fff; border-radius:12px; border:1px solid #e2e8f0; padding:60px 20px; text-align:center;">
                <div style="background:#f1f5f9; width:80px; height:80px; border-radius:50%; display:flex; align-items:center; justify-content:center; margin:0 auto 20px; border:1px solid #e2e8f0;">
                    <span class="dashicons dashicons-search" style="font-size:40px; width:40px; height:40px; color:#94a3b8;"></span>
                </div>
                <h3 style="margin:0 0 10px 0; color:#334155; font-size:18px;"><?php esc_html_e('No tools found', 'blyxxa-core'); ?></h3>
                <p style="margin:0; color:#64748b;"><?php esc_html_e('Try adjusting your search terms or create a new tool.', 'blyxxa-core'); ?></p>
            </div>
        <?php else : ?>
            
            <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px; padding:0 5px;">
                 <h2 style="margin:0; font-size:18px; font-weight:600; color:#334155;">
                     📦 <?php esc_html_e('Active Tools', 'blyxxa-core'); ?> 
                     <span style="background:#e2e8f0; color:#475569; padding:2px 10px; border-radius:12px; font-size:12px; margin-left:10px; vertical-align:middle;"><?php echo esc_html($total_files); ?></span>
                 </h2>
                 <div style="font-size:13px; color:#64748b;">
                    <?php 
                    /* translators: %s: Page number */
                    printf(esc_html__('Page %s', 'blyxxa-core'), $current_page); 
                    ?>
                 </div>
            </div>

            <div style="display:grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap:20px;">
                <?php 
                foreach ( $files as $file ) {
                    $basename = basename($file);
                    $slug = str_replace('.php', '', $basename);
                    // Extract shortcode from file content
                    $content = file_get_contents($file);
                    if (preg_match('/add_shortcode\s*\(\s*[\'"]([^\'"]+)[\'"]/', $content, $matches)) {
                        $shortcode = '[' . $matches[1] . ']';
                    } else {
                        $shortcode = '[tool_' . $slug . ']';
                    }
                    $del_url = wp_nonce_url(admin_url('admin.php?page=blyxxa-tool-manager&del='.$basename), 'del_tool');
                    
                    // Get Metadata: Category AND Role
                    $file_data = get_file_data($file, ['Category' => 'Category', 'Role' => 'Role', 'Title' => 'Title', 'Desc' => 'Description']);
                    $cat = !empty($file_data['Category']) ? $file_data['Category'] : 'General';
                    if($cat === '{{CATEGORY}}') $cat = 'Uncategorized';
                    
                    $title = !empty($file_data['Title']) ? $file_data['Title'] : $slug;
                    $desc = !empty($file_data['Desc']) ? $file_data['Desc'] : __('No description provided.', 'blyxxa-core');
                    
                    // Role Logic
                    $role_raw = !empty($file_data['Role']) ? strtolower(trim($file_data['Role'])) : 'member';
                    $role_badge = '';
                    
                    // Binary Logic: Free vs Premium
                    $free_roles = ['member', 'read', 'subscriber', '', 'free'];

                    // Get Status from Library
                    $lib_entry = isset($library_data[$slug]) ? $library_data[$slug] : [];
                    $status = isset($lib_entry['status']) ? $lib_entry['status'] : 'draft';
                    
                    // SYNCHRONOUS TOGGLE URL
                    $toggle_url = wp_nonce_url(
                        add_query_arg(['toggle_status' => $slug]), 
                        'blyx_status_toggle'
                    );

                    // STATUS BADGE (LINK)
                    if ($status === 'published') {
                        $status_badge = '<a href="'.esc_url($toggle_url).'" title="'.esc_attr__('Click to Unpublish', 'blyxxa-core').'" style="text-decoration:none;">
                            <span style="font-size:10px; display:inline-flex; align-items:center; gap:3px; color:#15803d; background:#dcfce7; padding:2px 6px; border-radius:12px; border:1px solid #bbf7d0; transition:0.2s;">
                                <span style="width:6px; height:6px; background:#16a34a; border-radius:50%;"></span> 
                                <span class="lbl">' . __('Published', 'blyxxa-core') . '</span>
                            </span>
                        </a>';
                    } else {
                        $status_badge = '<a href="'.esc_url($toggle_url).'" title="'.esc_attr__('Click to Publish', 'blyxxa-core').'" style="text-decoration:none;">
                            <span style="font-size:10px; display:inline-flex; align-items:center; gap:3px; color:#64748b; background:#f1f5f9; padding:2px 6px; border-radius:12px; border:1px solid #e2e8f0; transition:0.2s;">
                                <span style="width:6px; height:6px; background:#94a3b8; border-radius:50%;"></span> 
                                <span class="lbl">' . __('Draft', 'blyxxa-core') . '</span>
                            </span>
                        </a>';
                    }

                    
                     // DOWNGRADE CHECK FOR UI
                    $is_tool_allowed = true;
                    if (class_exists('Blyxxa_Client_License')) {
                        $lic_status = Blyxxa_Client_License::get_license_status();
                        if ($lic_status !== 'active') {
                            // Calculate allowed tool (Oldest)
                            // Use cached result if possible in loop, but here logic is quick enough
                            if(!isset($blyxxa_allowed_tool_path)) {
                                $all_ts = glob(BLYXXA_TOOLS_PATH . '*.php');
                                if($all_ts) {
                                    usort($all_ts, function($a, $b) { return filectime($a) - filectime($b); });
                                    $blyxxa_allowed_tool_path = realpath($all_ts[0]);
                                }
                            }
                            
                            if(isset($blyxxa_allowed_tool_path) && realpath($file) !== $blyxxa_allowed_tool_path) {
                                $is_tool_allowed = false;
                            }
                        }
                    }

                    if (!$is_tool_allowed) {
                        $role_badge = '<span style="font-size:11px; color:#991b1b; background:#fef2f2; padding:2px 8px; border-radius:4px; border:1px solid #fecaca; font-weight:600;">🔴 ' . esc_html__('Inactive (Plan Limit)', 'blyxxa-core') . '</span>';
                    } elseif(in_array($role_raw, $free_roles)) {
                        $role_badge = '<span style="font-size:11px; color:#166534; background:#dcfce7; padding:2px 8px; border-radius:4px; border:1px solid #86efac; font-weight:600;">Freemium</span>';
                    } else {
                        $role_badge = '<span style="font-size:11px; color:#92400e; background:#fef3c7; padding:2px 8px; border-radius:4px; border:1px solid #fcd34d; font-weight:600;">Premium</span>';
                    }
                    ?>
                    <div class="blyx-tool-card" style="background:#fff; border:1px solid #cbd5e1; border-radius:12px; overflow:hidden; transition:transform 0.2s, box-shadow 0.2s; display:flex; flex-direction:column;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 10px 15px -3px rgba(0,0,0,0.1)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                        <!-- Header -->
                        <div style="padding:15px; border-bottom:1px solid #f1f5f9; display:flex; justify-content:space-between; align-items:start; background:#f8fafc;">
                            <div style="display:flex; align-items:center; gap:10px; overflow:hidden;">
                                <div style="background:#fff; padding:6px; border-radius:8px; border:1px solid #e2e8f0; color:#0ea5e9; flex-shrink:0;">
                                    <span class="dashicons dashicons-media-code" style="font-size:20px; width:20px; height:20px;"></span>
                                </div>
                                <div style="overflow:hidden;">
                                    <h3 style="margin:0 0 2px 0; font-size:15px; font-weight:700; color:#334155; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;" title="<?php echo esc_attr($title); ?>">
                                        <?php echo esc_html($title); ?>
                                    </h3>
                                    <div style="display:flex; gap:5px; align-items:center;">
                                        <code style="font-size:11px; color:#94a3b8; background:#fff; padding:1px 4px; border:1px solid #e2e8f0; border-radius:4px;"><?php echo esc_html($slug); ?></code>
                                        <?php echo wp_kses_post($status_badge); ?>
                                    </div>
                                </div>
                                <span style="font-size:11px; color:#94a3b8; display:none;">.php</span>
                            </div>
                            <div style="flex-shrink:0;">
                                <?php echo wp_kses_post($role_badge); ?>
                            </div>
                        </div>

                        <!-- Body -->
                        <div style="padding:15px; flex:1;">
                            <div style="margin-bottom:12px; display:flex; align-items:center; justify-content:space-between;">
                                <div style="display:flex; align-items:center; gap:5px;">
                                    <span class="dashicons dashicons-category" style="font-size:14px; width:14px; height:14px; color:#94a3b8;"></span>
                                    <span style="font-size:12px; color:#64748b; font-weight:500;"><?php echo esc_html($cat); ?></span>
                                </div>
                                <button type="button" onclick="openChangeCatModal('<?php echo esc_js($basename); ?>', '<?php echo esc_js($cat); ?>')" style="background:none; border:none; color:#3b82f6; font-size:11px; cursor:pointer; font-weight:500; padding:0;"><?php esc_html_e('Change', 'blyxxa-core'); ?></button>
                            </div>

                            <div style="background:#ecfeff; border:1px dashed #22d3ee; border-radius:6px; padding:8px 10px; display:flex; align-items:center; justify-content:space-between;">
                                <code style="color:#0891b2; font-size:11px; font-family:'Consolas', monospace; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; max-width:180px;"><?php echo esc_html($shortcode); ?></code>
                                <button type="button" onclick="blyxxaCopy(this, '<?php echo esc_js($shortcode); ?>')" style="border:none; background:none; cursor:pointer; color:#0e7490; padding:0; display:flex; align-items:center;" title="<?php esc_attr_e('Copy Shortcode', 'blyxxa-core'); ?>">
                                    <span class="dashicons dashicons-clipboard" style="font-size:14px; width:14px; height:14px;"></span>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Footer -->
                        <div style="padding:10px 15px; background:#fff; border-top:1px solid #f1f5f9; display:flex; gap:10px;">
                            <a href="<?php echo esc_url(admin_url('admin.php?page=blyxxa-tool-factory&edit=' . $slug)); ?>" class="button button-small" style="flex:1; text-align:center; justify-content:center; display:flex; align-items:center; gap:5px;">
                                <span class="dashicons dashicons-edit" style="font-size:14px;"></span> <?php esc_html_e('Edit', 'blyxxa-core'); ?>
                            </a>
                            <a href="<?php echo esc_url($del_url); ?>" onclick="return confirm('<?php echo esc_js(__('Are you sure you want to delete this tool permanently?', 'blyxxa-core')); ?>');" class="button button-small" style="color:#dc2626; border-color:#fecaca; background:#fef2f2; flex:1; text-align:center; justify-content:center; display:flex; align-items:center; gap:5px;">
                                <span class="dashicons dashicons-trash" style="font-size:14px;"></span> <?php esc_html_e('Delete', 'blyxxa-core'); ?>
                            </a>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
            
            <?php if ($total_pages > 1) : ?>
                <div style="margin-top:30px; display:flex; justify-content:center; gap:5px;">
                    <?php 
                    $base_url = admin_url('admin.php?page=blyxxa-tool-manager');
                    if($search_query) $base_url .= '&s=' . urlencode($search_query);
                    
                    if($current_page > 1) echo '<a href="'.esc_url($base_url.'&p='.($current_page-1)).'" class="button" style="padding:5px 10px; height:auto;">«</a>';
                    
                    for($i=1; $i<=$total_pages; $i++) {
                        $active = ($i == $current_page) ? 'background:#0f172a; color:#fff; border-color:#0f172a;' : 'background:#fff;';
                        echo '<a href="'.esc_url($base_url.'&p='.$i).'" class="button" style="'.esc_attr($active).' padding:5px 10px; height:auto;">'.esc_html($i).'</a>';
                    }
                    
                    if($current_page < $total_pages) echo '<a href="'.esc_url($base_url.'&p='.($current_page+1)).'" class="button" style="padding:5px 10px; height:auto;">»</a>';
                    ?>
                </div>
            <?php endif; ?>

        <?php endif; ?>

        <div style="margin-top:30px; padding:15px; background:#fff3cd; border:1px solid #ffeeba; color:#856404; border-radius:8px; font-size:13px; display:flex; gap:10px; align-items:center;">
             <span class="dashicons dashicons-info" style="font-size:20px; color:#d97706;"></span>
             <div>
                <strong><?php esc_html_e('Tip:', 'blyxxa-core'); ?></strong> <?php echo wp_kses_post(__('Active tools are stored physically in <code>wp-content/plugins/blyxxa-core/tools/</code>.', 'blyxxa-core')); ?>
                <br>
                ✨ <strong><?php esc_html_e('All downloaded tools are fully editable!', 'blyxxa-core'); ?></strong> <?php esc_html_e('You can customize the prompt, language, and logic by clicking the "Edit" button.', 'blyxxa-core'); ?>
             </div>
        </div>

    </div>

    <!-- Change Category Modal -->
    <div id="blyx_change_cat_modal" class="blyx-modal-overlay" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:9999; justify-content:center; align-items:center;">
        <div class="blyx-modal" style="background:#fff; padding:25px; border-radius:12px; width:400px; box-shadow:0 10px 25px rgba(0,0,0,0.1);">
            <h3 style="margin-top:0; color:#334155;"><?php esc_html_e('Change Category', 'blyxxa-core'); ?></h3>
            <p style="color:#64748b; font-size:13px; margin-bottom:15px;"><?php esc_html_e('Select a new category for this tool:', 'blyxxa-core'); ?></p>
            
            <form method="post">
                <?php wp_nonce_field('blyx_tool_act'); ?>
                <input type="hidden" name="filename" id="modal_filename">
                <input type="hidden" name="blyxxa_update_cat" value="1">
                
                <div style="margin-bottom:20px;">
                    <select name="new_cat" id="modal_cat_select" style="width:100%; padding:8px; border:1px solid #cbd5e1; border-radius:6px;">
                        <!-- Populated via JS -->
                    </select>
                </div>
                
                <div style="display:flex; justify-content:flex-end; gap:10px;">
                    <button type="button" onclick="document.getElementById('blyx_change_cat_modal').style.display='none'" style="padding:8px 16px; border:1px solid #cbd5e1; background:#fff; border-radius:6px; cursor:pointer;"><?php esc_html_e('Cancel', 'blyxxa-core'); ?></button>
                    <button type="submit" class="button button-primary" style="background:#0ea5e9; border-color:#0ea5e9;"><?php esc_html_e('Save Changes', 'blyxxa-core'); ?></button>
                </div>
            </form>
        </div>
    </div>

    <script>
    window.blyxxaCopy = function(btn, text) {
        if (!navigator.clipboard) {
            alert('Clipboard API not supported');
            return;
        }
        navigator.clipboard.writeText(text).then(function() {
            let icon = btn.querySelector('.dashicons');
            let originalClass = icon.className;
            
            // Visual Feedback
            btn.style.color = '#10b981';
            icon.className = 'dashicons dashicons-yes';
            
            // Reset
            setTimeout(() => {
                btn.style.color = '#0e7490';
                icon.className = originalClass;
            }, 2000);
        }, function(err) {
            console.error('Copy failed', err);
            alert('Copy failed: ' + err);
        });
    };

    window.openChangeCatModal = function(filename, currentCat) {
        let modal = document.getElementById('blyx_change_cat_modal');
        let select = document.getElementById('modal_cat_select');
        
        // Set filename
        document.getElementById('modal_filename').value = filename;
        
        // Load categories
        select.innerHTML = '<option><?php echo esc_js(__('Loading...', 'blyxxa-core')); ?></option>';
        
        if(typeof ajaxurl === 'undefined') var ajaxurl = '/wp-admin/admin-ajax.php';
        
        let d = new FormData(); 
        d.append('action', 'blyxxa_manage_cats'); 
        d.append('mode', 'get');
        
        fetch(ajaxurl, {method:'POST', body:d}).then(r=>r.json()).then(res => {
            if(res.success) {
                select.innerHTML = '';
                res.data.forEach(c => {
                    let opt = new Option(c, c);
                    if(c === currentCat) opt.selected = true;
                    select.appendChild(opt);
                });
                modal.style.display = 'flex';
            } else {
                alert('Failed to load categories');
            }
        }).catch(err => console.error(err));
    };
    
    // Quick debug
    console.log('Blyxxa Tool Manager JS loaded. (Client)');
    </script>
    <?php
}