<?php
if (!defined('ABSPATH')) exit;

function blyxxa_license_manager_page() {
    $licenses = get_option('blyxxa_client_licenses', []);
    ?>
    <div class="wrap">
        <h1>📡 <?php esc_html_e('Client License Manager', 'blyxxa-core'); ?></h1>
        <p><?php esc_html_e('Track active licenses connected to your Master Node.', 'blyxxa-core'); ?></p>
        
        <div style="background:#fff; border:1px solid #ccd0d4; border-radius:4px; padding:20px; margin-top:20px;">
            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e('License Key', 'blyxxa-core'); ?></th>
                        <th><?php esc_html_e('Domain', 'blyxxa-core'); ?></th>
                        <th><?php esc_html_e('Email', 'blyxxa-core'); ?></th>
                        <th><?php esc_html_e('Last Check', 'blyxxa-core'); ?></th>
                        <th><?php esc_html_e('Status', 'blyxxa-core'); ?></th>
                        <th><?php esc_html_e('Actions', 'blyxxa-core'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($licenses)): ?>
                        <tr><td colspan="6"><?php esc_html_e('No active licenses found yet.', 'blyxxa-core'); ?></td></tr>
                    <?php else: ?>
                        <?php foreach($licenses as $key => $data): ?>
                            <tr>
                                <td><code><?php echo esc_html(substr($key, 0, 10) . '...'); ?></code></td>
                                <td><a href="http://<?php echo esc_attr($data['domain']); ?>" target="_blank"><?php echo esc_html($data['domain']); ?></a></td>
                                <td><?php echo esc_html($data['email']); ?></td>
                                <td><?php echo esc_html($data['last_check']); ?></td>
                                <td><span style="color:<?php echo ($data['status'] === 'active' ? 'green' : 'red'); ?>; font-weight:bold;"><?php echo esc_html__($data['status'], 'blyxxa-core'); ?></span></td>
                                <td>
                                    <form method="post" onsubmit="return confirm('<?php echo esc_js(__('Are you sure?', 'blyxxa-core')); ?>');">
                                        <?php wp_nonce_field('blyx_revoke_license_action'); ?>
                                        <input type="hidden" name="license_key" value="<?php echo esc_attr($key); ?>">
                                        <button type="submit" name="blyxxa_revoke_license" class="button button-small button-link-delete"><?php esc_html_e('Revoke', 'blyxxa-core'); ?></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php
    
    // Handle Revoke (Simple local removal for now)
    // Handle Revoke (Simple local removal for now)
    if(isset($_POST['blyxxa_revoke_license']) && check_admin_referer('blyx_revoke_license_action')) {
        $key = isset($_POST['license_key']) ? sanitize_text_field(wp_unslash($_POST['license_key'])) : '';
        if(isset($licenses[$key])) {
            unset($licenses[$key]);
            update_option('blyxxa_client_licenses', $licenses);
            echo "<script>window.location.reload();</script>";
        }
    }
}
