<?php
/*
 * Snippet: Blyxxa Tool Generator (v27.1 - Library Pro Edition)
 * Konum: Administration Area Only
 * Features: Project Library with Live Search & Pagination + Full Functionality
 */

function blyxxa_gen_page_v27() {
    // Defines
    $upgrade_url = 'https://blyxxa.gumroad.com/l/BlyxxaSaasEngine';
    
    // Enqueue Dashicons
    wp_enqueue_style('dashicons');

    // License & Limit Logic
    $is_premium = (class_exists('Blyxxa_Client_License') && Blyxxa_Client_License::get_license_status() === 'active');
    $tool_count = count(glob(BLYXXA_TOOLS_PATH . '*.php'));
    $free_limit = 1;
    $limit_reached = (!$is_premium && $tool_count >= $free_limit);
    
    // Enqueue SweetAlert2 for modern popups
    wp_enqueue_script('sweetalert2', 'https://cdn.jsdelivr.net/npm/sweetalert2@11', [], '11.0', true);
    ?>
    <script>
        var blyxConfig = {
            isPremium: <?php echo $is_premium ? 'true' : 'false'; ?>,
            limitReached: <?php echo $limit_reached ? 'true' : 'false'; ?>,
            toolCount: <?php echo esc_js($tool_count); ?>,
            strings: {
                limitTitle: "<?php echo esc_js(__('Free Limit Reached', 'blyxxa-core')); ?>",
                limitMsg: "<?php echo esc_js(__('You have reached the free limit of 1 tool. Upgrade to Pro for unlimited generation!', 'blyxxa-core')); ?>",
                firstToolTitle: "<?php echo esc_js(__('Congratulations! 🎉', 'blyxxa-core')); ?>",
                firstToolMsg: "<?php echo esc_js(__('You created your first AI tool! To create unlimited tools and unlock premium features, upgrade now.', 'blyxxa-core')); ?>",
                upgradeBtn: "<?php echo esc_js(__('Upgrade to Pro 🚀', 'blyxxa-core')); ?>",
                salesUrl: "https://blyxxa.gumroad.com/l/BlyxxaSaasEngine"
            },
            nonces: {
                save: '<?php echo esc_js(wp_create_nonce("blyx_lib_save")); ?>',
                del: '<?php echo esc_js(wp_create_nonce("blyx_lib_del")); ?>',
                get: '<?php echo esc_js(wp_create_nonce("blyx_lib_get")); ?>',
                cats: '<?php echo esc_js(wp_create_nonce("blyx_manage_cats")); ?>',
                gen: '<?php echo esc_js(wp_create_nonce("blyx_gen_process")); ?>'
            }
        };
    </script>
    <style>
        :root { --blyx-cyan: #06b6d4; --blyx-dark: #0f172a; --blyx-gray: #f1f5f9; }
        .swal2-container { z-index: 100000 !important; }
        .blyx-modal-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(15, 23, 42, 0.85); z-index: 9999; display: none; justify-content: center; align-items: center; backdrop-filter: blur(5px); }
        .blyx-modal { background: #fff; padding: 30px; width: 450px; border-radius: 16px; box-shadow: 0 25px 50px -12px rgba(0,0,0,0.4); position: relative; border-top: 4px solid var(--blyx-cyan); }
        .blyx-modal.large { width: 700px; min-height: 500px; display: flex; flex-direction: column; } 
        .blyx-modal h3 { margin-top: 0; color: var(--blyx-dark); font-size: 20px; border-bottom: 1px solid var(--blyx-gray); padding-bottom: 15px; font-weight:700; display:flex; justify-content:space-between; align-items:center; }
        .blyx-form-group { margin-bottom: 18px; }
        .blyx-form-group label { display: block; font-weight: 600; margin-bottom: 6px; color: #475569; font-size: 13px; text-transform: uppercase; letter-spacing: 0.5px; }
        .blyx-form-group input, .blyx-form-group select, .blyx-form-group textarea { width: 100%; padding: 12px; border: 1px solid #cbd5e1; border-radius: 8px; font-size: 14px; transition:all 0.2s; background:#f8fafc; box-sizing: border-box; }
        .blyx-form-group input:focus, .blyx-form-group textarea:focus { border-color: var(--blyx-cyan); background:#fff; outline:none; box-shadow: 0 0 0 3px rgba(6, 182, 212, 0.15); }
        .blyx-modal-footer { display: flex; justify-content: flex-end; gap: 10px; margin-top: 25px; border-top: 1px solid var(--blyx-gray); padding-top: 20px; }
        .blyx-btn-cancel { background: #fff; color: #64748b; border: 1px solid #cbd5e1; cursor: pointer; padding: 10px 18px; border-radius: 8px; font-weight: 600; }
        .blyx-btn-save { background: var(--blyx-cyan); color: #fff; border: none; cursor: pointer; padding: 10px 18px; border-radius: 8px; font-weight: 600; }
        .blyx-btn-save:hover { background: #0891b2; }
        .blyx-item-card { background:#fff; border:1px solid #e2e8f0; border-left:4px solid var(--blyx-cyan); border-radius:8px; margin-bottom:10px; padding:15px; display:flex; flex-direction:column; gap:8px; box-shadow:0 1px 3px rgba(0,0,0,0.05); }
        .blyx-card-header { display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid var(--blyx-gray); padding-bottom:10px; margin-bottom:5px; }
        .blyx-card-title { font-weight:700; color:var(--blyx-dark); font-size:15px; }
        .blyx-mini-btn { padding:5px 10px; font-size:12px; cursor:pointer; border:1px solid #e2e8f0; background:#fff; border-radius:6px; color:#475569; font-weight:600; display:inline-flex; align-items:center; text-decoration:none; }
        .blyx-mini-btn:hover { background:var(--blyx-cyan); color:#fff; border-color:var(--blyx-cyan); }
        .blyx-btn-del:hover { background:#fef2f2; color:#dc2626; border-color:#fecaca; }
        .blyx-add-btn { padding:12px; cursor:pointer; border:1px solid #cbd5e1; background:#fff; border-radius:8px; font-weight:600; color:#475569; display:flex; align-items:center; justify-content:center; gap:8px; }
        .blyx-add-btn:hover { background:var(--blyx-cyan); border-color:var(--blyx-cyan); color:#fff; }
        .blyx-add-btn.primary { background:var(--blyx-dark); border-color:var(--blyx-dark); color:#fff; }
        .blyx-add-btn.primary:hover { background:var(--blyx-cyan); border-color:var(--blyx-cyan); color:#fff; }
        
        /* LIBRARY & PAGINATION STYLES */
        .blyx-lib-search { width: 100%; padding: 12px; border: 1px solid #cbd5e1; border-radius: 8px; margin-bottom: 15px; font-size: 14px; background: #f8fafc url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24' stroke='%2394a3b8'%3E%3Cpath stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z'/%3E%3C/svg%3E") no-repeat 12px center; background-size: 20px; padding-left: 40px; box-sizing: border-box; }
        .blyx-lib-search:focus { border-color: var(--blyx-cyan); background-color: #fff; outline: none; }
        .blyx-lib-list-container { flex: 1; overflow-y: auto; margin-bottom: 15px; border: 1px solid #e2e8f0; border-radius: 8px; }
        .blyx-lib-item { display: flex; justify-content: space-between; align-items: center; padding: 15px; border-bottom: 1px solid #f1f5f9; transition: 0.2s; }
        .blyx-lib-item:last-child { border-bottom: none; }
        .blyx-lib-item:hover { background: #f8fafc; }
        .blyx-lib-info h4 { margin: 0 0 5px 0; color: var(--blyx-dark); font-size: 15px; }
        .blyx-lib-info span { color: #64748b; font-size: 12px; font-family: monospace; background: #e2e8f0; padding: 2px 6px; border-radius: 4px; }
        .blyx-lib-actions { display: flex; gap: 8px; }
        .blyx-pagination { display: flex; justify-content: space-between; align-items: center; padding-top: 10px; border-top: 1px solid #e2e8f0; }
        .blyx-page-btn { padding: 8px 16px; border: 1px solid #cbd5e1; background: #fff; border-radius: 6px; cursor: pointer; font-size: 13px; color: #475569; }
        .blyx-page-btn:disabled { opacity: 0.5; cursor: not-allowed; }
        .blyx-page-btn:not(:disabled):hover { border-color: var(--blyx-cyan); color: var(--blyx-cyan); }
        .blyx-page-info { font-size: 13px; color: #64748b; font-weight: 600; }
    </style>

    <div class="wrap" style="font-family: 'Inter', sans-serif; max-width: 1400px;">
        <div style="background: linear-gradient(135deg, var(--blyx-dark) 0%, #1e293b 100%); color:#fff; padding:30px; border-radius:16px; box-shadow:0 20px 40px -10px rgba(15, 23, 42, 0.3); margin-bottom:30px; display:flex; align-items:center; justify-content: space-between; gap:20px; border-bottom: 4px solid var(--blyx-cyan);">
            <div style="display:flex; align-items:center; gap:20px;">
                <div style="background:var(--blyx-cyan); padding:10px; border-radius:12px;">
                    <span class="dashicons dashicons-hammer" style="font-size:40px; width:40px; height:40px; color:#fff;"></span>
                </div>
                <div>
                    <h1 style="color:#fff; margin:0; font-size:28px; font-weight:800; letter-spacing:-0.5px;">Blyxxa Tool Factory <span style="font-size:14px; background:var(--blyx-cyan); padding:4px 10px; border-radius:20px; font-weight:700;text-transform:uppercase; vertical-align: middle;">v<?php echo esc_html(BLYXXA_VERSION); ?> Library Pro</span></h1>
                    <p style="margin:8px 0 0 0; opacity:0.8; font-size:15px;"><?php esc_html_e('Master Prompt Embedded Production Center', 'blyxxa-core'); ?></p>
                </div>
            </div>
            <div style="display:flex; gap:10px;">
                <button onclick="saveProject()" class="blyx-add-btn" style="background:rgba(255,255,255,0.1); border:1px solid rgba(255,255,255,0.2); color:#fff;">💾 <?php esc_html_e('Save Draft', 'blyxxa-core'); ?></button>
                <button onclick="openLibrary()" class="blyx-add-btn" style="background:#fff; border:none; color:var(--blyx-dark);">📂 <?php esc_html_e('Library', 'blyxxa-core'); ?></button>
            </div>
        </div>
        
        <div class="blyx-card" style="margin-bottom: 20px; border-left: 4px solid #6366f1;">
            <div class="blyx-card-header">
                <h3>🚀 <?php esc_html_e('AI Tool Architect (Experimental)', 'blyxxa-core'); ?></h3>
                <p style="margin:0; opacity:0.8; font-size:0.9em;"><?php esc_html_e('Describe the tool you want to create. The AI will build it for you using the Master Architect protocols.', 'blyxxa-core'); ?></p>
            </div>
            <div class="blyx-card-body" style="display: flex; gap: 20px; align-items: flex-start;">
                <div style="flex: 2;">
                    <textarea id="import_text" style="width:100%; height:100px; padding:12px; border:1px solid #ddd; border-radius:8px; font-family:sans-serif; font-size:14px;" placeholder="<?php esc_attr_e('Example: Create an SEO Keyword Generator that asks for a topic and target country, then outputs a table of keywords with search volume estimates...', 'blyxxa-core'); ?>"></textarea>
                </div>
                <div style="flex: 1; display: flex; flex-direction: column; gap: 10px;">
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600; font-size:12px;"><?php esc_html_e('Select Architect AI', 'blyxxa-core'); ?></label>
                        <select id="import_ai_model_select" style="width:100%; padding:8px; border-radius:6px;">
                            <option disabled selected><?php esc_html_e('Loading Models...', 'blyxxa-core'); ?></option>
                        </select>
                    </div>
                    <button id="btn_import_action" class="blyx-btn blyx-btn-primary" onclick="parseImport()" style="width:100%; justify-content:center;">
                        ✨ <?php esc_html_e('Generate Tool', 'blyxxa-core'); ?>
                    </button>
                </div>
            </div>
        </div>
        
        <div style="display:flex; gap:25px; align-items:flex-start; flex-wrap:wrap;">
            <div style="flex:1; min-width:400px; background:#fff; padding:30px; border:1px solid #e2e8f0; border-radius:16px; box-shadow:0 4px 6px -1px rgba(0, 0, 0, 0.05);">
                <h3 style="margin-top:0; border-bottom:2px solid var(--blyx-gray); padding-bottom:15px; margin-bottom:20px; color:var(--blyx-dark);"><?php esc_html_e('1. Tool Configuration', 'blyxxa-core'); ?></h3>
                <div id="blyx_cat_manager" class="blyx-modal-overlay">
        <div class="blyx-modal">
            <h3><?php esc_html_e('Category Manager', 'blyxxa-core'); ?> <button onclick="closeCatManager()" style="background:none; border:none; font-size:20px; cursor:pointer; float:right;">&times;</button></h3>
            
            <div style="display:flex; gap:10px; margin-bottom:20px; border-bottom:1px solid #f1f5f9; padding-bottom:15px;">
                <input type="text" id="new_cat_input" placeholder="<?php esc_attr_e('New Category Name...', 'blyxxa-core'); ?>" style="flex:1; padding:10px; border:1px solid #cbd5e1; border-radius:6px;">
                <button onclick="manageCat('add')" class="blyx-btn-save" style="padding:10px 15px;">+</button>
            </div>

            <div id="cat_list_container" style="max-height:300px; overflow-y:auto;">
                <!-- Categories will be loaded here -->
                <div style="text-align:center; color:#94a3b8;"><?php esc_html_e('Loading...', 'blyxxa-core'); ?></div>
            </div>
        </div>
    </div>
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:15px;">
                    <div class="blyx-form-group"><label><?php esc_html_e('Tool ID', 'blyxxa-core'); ?></label><input type="text" id="t_id" placeholder="rn: viral_hook_gen"></div>
                    <div class="blyx-form-group">
                        <label><?php esc_html_e('Category', 'blyxxa-core'); ?></label>
                        <div style="display:flex; gap:5px;">
                            <select id="t_cat" style="flex:1;"></select>
                            <button onclick="openCatManager()" class="blyx-add-btn" style="padding:0 12px;" title="<?php esc_attr_e('Manage Categories', 'blyxxa-core'); ?>">⚙️</button>
                        </div>
                    </div>
                    <div class="blyx-form-group"><label><?php esc_html_e('Access Role', 'blyxxa-core'); ?></label><select id="t_role"><option value="member">👤 <?php esc_html_e('Free (Everyone)', 'blyxxa-core'); ?></option><option value="premium">🌟 <?php esc_html_e('Premium (Subscribers)', 'blyxxa-core'); ?></option></select></div>
                </div>
                <div class="blyx-form-group"><label><?php esc_html_e('Title', 'blyxxa-core'); ?></label><input type="text" id="t_title" placeholder='rn: "Viral" Hook Architect'></div>
                <div class="blyx-form-group"><label><?php esc_html_e('Description', 'blyxxa-core'); ?></label><input type="text" id="t_desc" placeholder='<?php esc_attr_e('Short and catchy description...', 'blyxxa-core'); ?>'></div>

                <h3 style="margin-top:30px; border-bottom:2px solid var(--blyx-gray); padding-bottom:15px; margin-bottom:20px; display:flex; justify-content:space-between; align-items:center; color:var(--blyx-dark);">
                    <?php esc_html_e('2. User Inputs', 'blyxxa-core'); ?>
                    <span style="font-size:12px; font-weight:500; color:var(--blyx-cyan); background:#ecfeff; padding:4px 10px; border-radius:6px; border:1px solid #cffafe;"><?php esc_html_e('Use arrows for sorting', 'blyxxa-core'); ?></span>
                </h3>
                <div id="inp_list" style="margin-bottom:20px; min-height:50px;"></div>
                
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
                    <button class="blyx-add-btn" onclick="openModal('text')"><span class="dashicons dashicons-editor-textcolor"></span> <?php esc_html_e('Text', 'blyxxa-core'); ?></button>
                    <button class="blyx-add-btn" onclick="openModal('textarea')"><span class="dashicons dashicons-text"></span> <?php esc_html_e('Text Area', 'blyxxa-core'); ?></button>
                    <button class="blyx-add-btn" onclick="openModal('select')"><span class="dashicons dashicons-menu"></span> <?php esc_html_e('Select List', 'blyxxa-core'); ?></button>
                    <button class="blyx-add-btn" onclick="openModal('number')"><span class="dashicons dashicons-calculator"></span> <?php esc_html_e('Number', 'blyxxa-core'); ?></button>
                    <button class="blyx-add-btn" onclick="openModal('file')"><span class="dashicons dashicons-format-image"></span> <?php esc_html_e('File/Image', 'blyxxa-core'); ?></button>
                    <button class="blyx-add-btn primary" onclick="openModal('checkbox')" style="grid-column: 1 / -1;"><span class="dashicons dashicons-yes"></span> <?php esc_html_e('Checkbox (Conditional)', 'blyxxa-core'); ?></button>
                </div>
            </div>
            
            <div style="flex:1.3; min-width:400px; background:#fff; padding:30px; border:1px solid #e2e8f0; border-radius:16px; box-shadow:0 4px 6px -1px rgba(0, 0, 0, 0.05);">
                <h3 style="margin-top:0; border-bottom:2px solid var(--blyx-gray); padding-bottom:15px; margin-bottom:20px; color:var(--blyx-dark);"><?php esc_html_e('3. Tool Task (Dynamic)', 'blyxxa-core'); ?></h3>
                <div style="background:#f0fdfa; padding:15px; margin-bottom:15px; border-radius:8px; border:1px solid #ccfbf1; color:#115e59; font-size:13px;">
                    <strong>ℹ️ <?php esc_html_e('INFO:', 'blyxxa-core'); ?></strong> <?php esc_html_e('"Blyxxa Master Prompt" (Constitution) is embedded in the system. Write only the specific task for this tool here.', 'blyxxa-core'); ?>
                </div>
                <div style="background:#f8fafc; padding:15px; margin-bottom:15px; border-radius:8px; border:1px solid #e2e8f0;">
                    <strong style="display:block; margin-bottom:8px; color:#475569; font-size:12px; text-transform:uppercase;"><?php esc_html_e('Available Variables:', 'blyxxa-core'); ?></strong> 
                    <div id="vars_display" style="display:flex; flex-wrap:wrap; gap:5px; min-height:20px;"><span style="color:#94a3b8; font-style:italic; font-size:12px;"><?php esc_html_e('No input added yet...', 'blyxxa-core'); ?></span></div>
                </div>
                <textarea id="t_prompt" style="width:100%; height:350px; font-family:'Consolas', monospace; line-height:1.6; padding:20px; border:1px solid #cbd5e1; border-radius:8px; background:var(--blyx-dark); color:#e2e8f0;" placeholder="<?php esc_attr_e('Ex: Create 10 viral hooks about the {topic} entered by the user...', 'blyxxa-core'); ?>"></textarea>
                <br><br>
                <div class="blyx-card-actions">
        <!-- LIMIT BUTTON -->
        <div id="btn_limit_reached" style="background:#cbd5e1; color:#fff; padding:20px; border-radius:8px; text-align:center; font-weight:800; font-size:18px; cursor:not-allowed; display: <?php echo ($limit_reached && !$is_premium && !isset($_GET['edit'])) ? 'block' : 'none'; ?>;">
            🔒 <?php esc_html_e('FREE LIMIT REACHED', 'blyxxa-core'); ?>
            <div style="font-size:12px; font-weight:400; color:#64748b; margin-top:5px;">
                <?php echo esc_html__('You have used your 1 free tool allowance.', 'blyxxa-core'); ?> 
                <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" style="color:#06b6d4; text-decoration:underline;"><?php echo esc_html__('Upgrade to Pro', 'blyxxa-core'); ?></a>
            </div>
        </div>

        <!-- GENERATE BUTTON -->
        <button id="btn_generate_tool" class="button button-primary button-hero" onclick="generateOnServer()" style="width:100%; padding:18px; font-size:16px; font-weight:800; background:var(--blyx-cyan); border:none; color:#fff; border-radius:8px; transition:0.2s; display: <?php echo ($limit_reached && !$is_premium && !isset($_GET['edit'])) ? 'none' : 'flex'; ?>; flex-direction:column; align-items:center; justify-content:center;">
            <span>✨ <?php esc_html_e('CREATE TOOL', 'blyxxa-core'); ?></span>
        </button>
    </div>
            </div>
        </div>

        <div id="output_wrap" style="margin-top:40px; display:none;">
            <div style="background:#fff; border:1px solid var(--blyx-cyan); border-top:4px solid var(--blyx-cyan); padding:30px; border-radius:16px; box-shadow:0 20px 50px -10px rgba(6, 182, 212, 0.15);">
                <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:20px;">
                    <h2 style="margin:0; color:var(--blyx-dark); display:flex; align-items:center; gap:10px;"><span class="dashicons dashicons-yes-alt" style="color:var(--blyx-cyan); font-size:30px;"></span> Kod Başarıyla Hazırlandı!</h2>
                    <span id="shortcode_res" style="background:#ecfeff; color:#0e7490; padding:10px 20px; border:1px solid #cffafe; border-radius:8px; font-family:monospace; font-weight:bold; font-size:15px;"></span>
                </div>
                <textarea id="final_code" style="width:100%; height:500px; background:var(--blyx-dark); color:#cbd5e1; font-family:'Consolas', monospace; white-space:pre; padding:20px; border-radius:8px; border:none;" readonly></textarea>
                <br><br>
                <br><br>
                <button class="button button-large" onclick="copyCode()" style="background:var(--blyx-cyan); color:white; border:none; padding:14px 28px; font-weight:bold; border-radius:8px; font-size:16px; display:flex; align-items:center; gap:10px;"><span class="dashicons dashicons-clipboard"></span> <?php esc_html_e('Copy Code', 'blyxxa-core'); ?></button>
                
                <!-- DEPLOY SECTION -->
                <div style="margin-top:30px; padding-top:30px; border-top:1px dashed #cbd5e1;">
                    <h3 style="margin:0 0 15px 0; color:var(--blyx-dark);">🚀 <?php esc_html_e('Deploy Tool', 'blyxxa-core'); ?></h3>
                    <div style="display:flex; gap:15px; align-items:center; background:#f8fafc; padding:20px; border-radius:12px; border:1px solid #e2e8f0;">
                        <div style="flex:1;">
                            <label style="display:block; font-weight:600; margin-bottom:5px; color:#475569;"><?php esc_html_e('Filename', 'blyxxa-core'); ?></label>
                            <div style="display:flex; align-items:center;">
                                <input type="text" id="deploy_filename" placeholder="tool-slug" style="width:100%; padding:12px; border:1px solid #cbd5e1; border-radius:6px 0 0 6px;">
                                <span style="background:#e2e8f0; border:1px solid #cbd5e1; border-left:none; padding:12px 15px; border-radius:0 6px 6px 0; color:#64748b; font-weight:600;">.php</span>
                            </div>
                        </div>
                        <button onclick="deployTool()" class="button button-primary button-hero" style="background:var(--blyx-dark); border:none; padding:12px 25px; height:auto; font-size:15px; display:flex; align-items:center; gap:8px;">
                            <span class="dashicons dashicons-cloud-upload"></span> <?php esc_html_e('Save & Activate', 'blyxxa-core'); ?>
                        </button>
                    </div>
                    <div id="deploy_res" style="margin-top:15px; display:none;"></div>
                </div>
            </div>
        </div>
    </div>

    <div id="blyx_modal_overlay" class="blyx-modal-overlay">
        <div class="blyx-modal">
            <h3 id="modal_title">Yeni Değişken</h3>
            <input type="hidden" id="m_index" value="-1">
            <div class="blyx-form-group"><label>Değişken Adı (İngilizce)</label><input type="text" id="m_name" placeholder="rn: topic"></div>
            <div class="blyx-form-group"><label>Etiket (Görünen İsim)</label><input type="text" id="m_label" placeholder="rn: Konu Başlığı"></div>
            
            <div id="m_ph_group" class="blyx-form-group">
                <label>Yer Tutucu (Placeholder)</label>
                <textarea id="m_ph" rows="3" placeholder="rn: Örn: Yapay zeka..."></textarea>
            </div>
            
            <div id="m_opts_group" class="blyx-form-group" style="display:none;"><label>Seçenekler (Her satıra bir tane)</label><textarea id="m_opts" rows="4" placeholder="Seçenek 1&#10;Seçenek 2"></textarea></div>
            <div id="m_chk_group" class="blyx-form-group" style="display:none;"><label>Seçilirse Prompt'a Eklenecek Komut</label><textarea id="m_chk_val" rows="2" placeholder="Örn: Use emojis within the text."></textarea></div>
            <div class="blyx-modal-footer"><button class="blyx-btn-cancel" onclick="closeModal()">İptal</button><button class="blyx-btn-save" onclick="saveInput()">✅ Kaydet</button></div>
        </div>
    </div>

    <div id="blyx_lib_overlay" class="blyx-modal-overlay">
        <div class="blyx-modal large">
            <h3>📂 Proje Kütüphanesi <button onclick="document.getElementById('blyx_lib_overlay').style.display='none'" style="background:none; border:none; font-size:20px; cursor:pointer;">&times;</button></h3>
            
            <input type="text" id="blyx_lib_search" class="blyx-lib-search" placeholder="Ara: ID veya Başlık..." oninput="renderLibraryPage()">
            
            <div id="blyx_lib_list" class="blyx-lib-list-container"><?php esc_html_e('Loading...', 'blyxxa-core'); ?></div>
            
            <div class="blyx-pagination">
                <button id="lib_prev" class="blyx-page-btn" onclick="changeLibPage(-1)">« <?php esc_html_e('Previous', 'blyxxa-core'); ?></button>
                <span id="lib_page_info" class="blyx-page-info"><?php esc_html_e('Page', 'blyxxa-core'); ?> 1 / 1</span>
                <button id="lib_next" class="blyx-page-btn" onclick="changeLibPage(1)"><?php esc_html_e('Next', 'blyxxa-core'); ?> »</button>
            </div>
        </div>
    </div>



    
    <?php
    $edit_id = isset($_GET['edit']) ? sanitize_text_field(wp_unslash($_GET['edit'])) : '';
    $edit_data = null;
    
    // JUST-IN-TIME RECOVERY: Restore missing library data from file
    $lib = get_option('blyxxa_tool_library', []);
    if($edit_id && !isset($lib[$edit_id])) {
        $file_path = BLYXXA_TOOLS_PATH . sanitize_file_name($edit_id) . '.php';
        if(file_exists($file_path)) {
            $f_content = file_get_contents($file_path);
            
            // Safer Extraction using specific anchor
            $parts = explode('// Include Master Template', $f_content);
            if(count($parts) > 1) {
                $raw_config = $parts[0];
                // Regex updated to handle both legacy $tool_config and new $blyxxa_tool_config
                $raw_config = preg_replace('/^\s*<\?php.*(?:\$tool_config|\$blyxxa_tool_config)\s*=\s*/s', '', $raw_config);
                $raw_config = trim($raw_config);
                if(substr($raw_config, -1) === ';') {
                    $raw_config = substr($raw_config, 0, -1);
                }

                try {
                    // phpcs:ignore Generic.PHP.ForbiddenFunctions.Found
                    $recovered_data = eval('return ' . $raw_config . ';');
                    if(is_array($recovered_data)) {
                        $lib[$edit_id] = $recovered_data;
                        update_option('blyxxa_tool_library', $lib);
                    }
                } catch(Exception $e) { }
            }
        }
    }

    if($edit_id) {
        if(isset($lib[$edit_id])) $edit_data = $lib[$edit_id];
    }
    ?>

    <script>
    let inputs = []; let currentType = 'text';
    
    // Auto-Load for Edit Mode
    const editData = <?php echo $edit_data ? json_encode($edit_data) : 'null'; ?>;
    // Initialization moved to bottom of script to handle dependencies
    document.getElementById('t_id').addEventListener('input', function(e){ e.target.value = e.target.value.replace(/[^a-z0-9_]/g, '_').toLowerCase(); });
    document.getElementById('m_name').addEventListener('input', function(e){ e.target.value = e.target.value.replace(/[^a-z0-9_]/g, '_').toLowerCase(); });

    function openModal(type, index = -1) {
        currentType = type;
        document.getElementById('m_index').value = index;
        document.getElementById('m_name').value = ''; document.getElementById('m_label').value = '';
        document.getElementById('m_opts').value = ''; document.getElementById('m_ph').value = ''; document.getElementById('m_chk_val').value = '';
        if(index > -1) {
            let item = inputs[index];
            currentType = item.type;
            document.getElementById('m_name').value = item.name; document.getElementById('m_label').value = item.label;
            document.getElementById('m_opts').value = item.opts || ''; document.getElementById('m_ph').value = item.ph || '';
            document.getElementById('m_chk_val').value = item.chk_val || ''; document.getElementById('modal_title').innerText = '<?php echo esc_js(__('Edit', 'blyxxa-core')); ?>';
        } else { document.getElementById('modal_title').innerText = '<?php echo esc_js(__('Add New', 'blyxxa-core')); ?>'; }
        document.getElementById('m_opts_group').style.display = (currentType === 'select') ? 'block' : 'none';
        document.getElementById('m_chk_group').style.display = (currentType === 'checkbox') ? 'block' : 'none';
        document.getElementById('m_ph_group').style.display = (currentType !== 'select' && currentType !== 'checkbox') ? 'block' : 'none';
        document.getElementById('blyx_modal_overlay').style.display = 'flex'; document.getElementById('m_name').focus();
    }
    function closeModal() { document.getElementById('blyx_modal_overlay').style.display = 'none'; }
    function saveInput() {
        let idx = parseInt(document.getElementById('m_index').value);
        let name = document.getElementById('m_name').value; let label = document.getElementById('m_label').value || name;
        let opts = document.getElementById('m_opts').value; let ph = document.getElementById('m_ph').value;
        let chk_val = document.getElementById('m_chk_val').value;
        if(!name) { 
            Swal.fire({
                icon: 'warning',
                title: '<?php echo esc_js(__('Missing Info', 'blyxxa-core')); ?>',
                text: '<?php echo esc_js(__('Variable name required!', 'blyxxa-core')); ?>'
            });
            return; 
        }
        let newItem = {type: currentType, name, label, opts, ph, chk_val};
        if(idx > -1) inputs[idx] = newItem; else inputs.push(newItem); render(); closeModal();
    }
    function render() {
        let h = '', v = '';
        inputs.forEach((i,x) => {
            let iconClass = 'dashicons-editor-textcolor';
            if(i.type=='textarea') iconClass='dashicons-text';
            if(i.type=='select') iconClass='dashicons-menu'; 
            if(i.type=='number') iconClass='dashicons-calculator';
            if(i.type=='checkbox') iconClass='dashicons-yes';
            if(i.type=='file') iconClass='dashicons-format-image';
            
            let icon = `<span class="dashicons ${iconClass}" style="font-size:16px; width:16px; height:16px; vertical-align:middle; color:#64748b;"></span>`;
            
            let details = (i.type == 'select') ? (i.opts.replace(/\n/g, ', ').substring(0,30)) : (i.type=='checkbox' ? i.chk_val.substring(0,30) : i.ph);
            let btns = `<a class="blyx-mini-btn" onclick="duplicate(${x})">📑</a> <a class="blyx-mini-btn" onclick="openModal('${i.type}', ${x})">✏️</a> <a class="blyx-mini-btn blyx-btn-del" onclick="del(${x})">🗑</a>`;
            let move = `<div>${x>0?`<a class="blyx-mini-btn" onclick="move(${x},-1)">⬆</a>`:''} ${x<inputs.length-1?`<a class="blyx-mini-btn" onclick="move(${x},1)">⬇</a>`:''}</div>`;
            h += `<div class="blyx-item-card"><div class="blyx-card-header"><div class="blyx-card-title">${icon} ${i.label} <span class="blyx-card-var">{${i.name}}</span></div>${move}</div><div class="blyx-card-details">${details}</div><div class="blyx-card-actions">${btns}</div></div>`;
            v += `<span onclick="ins('{${i.name}}')" style="cursor:pointer; background:#eff6ff; color:#1d4ed8; padding:4px 8px; border-radius:4px; font-weight:bold; font-size:12px;">{${i.name}}</span>`;
        });
        document.getElementById('inp_list').innerHTML = h || '<div style="text-align:center; color:#94a3b8; padding:20px; border:2px dashed #e2e8f0; border-radius:8px; margin-bottom:20px;"><?php echo esc_js(__('No inputs added yet. Use the buttons below.', 'blyxxa-core')); ?></div>';
        document.getElementById('vars_display').innerHTML = v || '<span style="color:#94a3b8; font-style:italic; font-size:12px;"><?php echo esc_js(__('No variables yet...', 'blyxxa-core')); ?></span>';
    }
    function del(x) { if(confirm('<?php echo esc_js(__('Are you sure you want to delete?', 'blyxxa-core')); ?>')) { inputs.splice(x,1); render(); } }
    function move(i, s) { let t = inputs[i]; inputs[i] = inputs[i+s]; inputs[i+s] = t; render(); }
    function duplicate(i) { let n = JSON.parse(JSON.stringify(inputs[i])); n.name+='_cp'; n.label+=' (Copy)'; inputs.push(n); render(); }
    function ins(t) { let e=document.getElementById('t_prompt'); e.setRangeText(t, e.selectionStart, e.selectionEnd, 'end'); e.focus(); }
    function showLimitPopup() {
        Swal.fire({
            title: blyxConfig.strings.limitTitle,
            text: blyxConfig.strings.limitMsg,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: blyxConfig.strings.upgradeBtn,
            confirmButtonColor: '#06b6d4',
            cancelButtonText: '<?php echo esc_js(__('Later', 'blyxxa-core')); ?>'
        }).then((result) => {
            if (result.isConfirmed) {
                window.open(blyxConfig.strings.salesUrl, '_blank');
            }
        });
    }

    function generateOnServer() {
        // ALLOW bypassed if updating (ID is Locked OR editData exists)
        let isUpdate = document.getElementById('t_id').readOnly || (typeof editData !== 'undefined' && editData !== null);
        
        if(blyxConfig.limitReached && !isUpdate) {
            showLimitPopup();
            return;
        }

        if(!document.getElementById('t_id').value) { 
            Swal.fire({icon:'warning', title:'<?php echo esc_js(__('Missing ID', 'blyxxa-core')); ?>', text:'<?php echo esc_js(__('Please enter a Tool ID!', 'blyxxa-core')); ?>'}); 
            return; 
        }
        let data = new FormData();
        data.append('action', 'blyxxa_gen_v27_process'); 
        data.append('id', document.getElementById('t_id').value);
        data.append('title', document.getElementById('t_title').value);
        data.append('cat', document.getElementById('t_cat').value);
        data.append('desc', document.getElementById('t_desc').value);
        data.append('role', document.getElementById('t_role').value);
        data.append('prompt', document.getElementById('t_prompt').value);
        data.append('inputs', JSON.stringify(inputs));
        // Pass tool check manually too for server safety
        data.append('tool_count', blyxConfig.toolCount);
        data.append('is_premium', blyxConfig.isPremium ? 1 : 0);
        data.append('nonce', blyxConfig.nonces.gen);
        
        document.getElementById('final_code').value = "<?php echo esc_js(__('Writing code... Please wait.', 'blyxxa-core')); ?>";
        document.getElementById('output_wrap').style.display = 'block';
        window.scrollTo({ top: document.body.scrollHeight, behavior: 'smooth' });
        
        fetch(ajaxurl, {method:'POST', body:data}).then(r=>r.text()).then(text=>{
            try {
                let res = JSON.parse(text);
                if(res.success) {
                    document.getElementById('final_code').value = res.data.code;
                    document.getElementById('shortcode_res').innerText = res.data.shortcode;
                    
                    let df = document.getElementById('deploy_filename');
                    df.value = document.getElementById('t_id').value;
                    df.readOnly = true;
                    df.style.backgroundColor = '#f1f5f9';
                    df.style.cursor = 'not-allowed';
                    
                    // Show SUCCESS POPUP for Free Users
                    // Show SUCCESS POPUP for Free Users ONLY for NEW tools
                    // If ID is locked (Edit Mode), do NOT show this popup.
                    let isUpdate = document.getElementById('t_id').readOnly;
                    
                    if(!blyxConfig.isPremium && !isUpdate) {
                        Swal.fire({
                            title: blyxConfig.strings.firstToolTitle,
                            text: blyxConfig.strings.firstToolMsg,
                            icon: 'success',
                            showCancelButton: true,
                            confirmButtonText: blyxConfig.strings.upgradeBtn,
                            confirmButtonColor: '#06b6d4',
                            cancelButtonText: '<?php echo esc_js(__('Continue Editing', 'blyxxa-core')); ?>',
                            footer: '<a href="' + blyxConfig.strings.salesUrl + '" target="_blank">Why upgrade?</a>'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.open(blyxConfig.strings.salesUrl, '_blank');
                            }
                            // DO NOT RELOAD. User needs to Save & Deploy.
                        });
                    } else if (isUpdate) {
                        // Optional: Small toast for update success
                         Swal.fire({
                            icon: 'success',
                            title: '<?php echo esc_js(__('Strategy Updated', 'blyxxa-core')); ?>',
                            text: '<?php echo esc_js(__('Review the code below and click Deploy to apply changes.', 'blyxxa-core')); ?>',
                            timer: 2000,
                            showConfirmButton: false,
                            toast: true,
                            position: 'top-end'
                        });
                    }
                } else { 
                    Swal.fire({
                        icon: 'error',
                        title: '<?php echo esc_js(__('Generation Error', 'blyxxa-core')); ?>',
                        text: res.data
                    });
                }
            } catch(e) { 
                console.log(text); 
                Swal.fire({icon: 'error', title: '<?php echo esc_js(__('Server Error', 'blyxxa-core')); ?>', text: '<?php echo esc_js(__('Server Error!', 'blyxxa-core')); ?>'}); 
            }
        });
    }
    function copyCode() { 
        document.getElementById('final_code').select(); 
        document.execCommand('copy'); 
        Swal.fire({
            icon: 'success',
            title: '<?php echo esc_js(__('Copied!', 'blyxxa-core')); ?>',
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 1500
        });
    }

    function deployTool() {
        let filename = document.getElementById('deploy_filename').value;
        let content = document.getElementById('final_code').value;
        if(!filename) { 
            Swal.fire({icon:'warning', title:'<?php echo esc_js(__('Missing Info', 'blyxxa-core')); ?>', text:'<?php echo esc_js(__('Please enter a filename.', 'blyxxa-core')); ?>'}); 
            return; 
        }
        
        // LOADING STATE
        let btn = document.querySelector('button[onclick="deployTool()"]');
        let originalText = btn.innerHTML;
        btn.innerHTML = '<span class="dashicons dashicons-update" style="animation:spin 1s infinite linear;"></span> <?php echo esc_js(__('Saving...', 'blyxxa-core')); ?>';
        btn.disabled = true;
        
        let data = new FormData();
        data.append('action', 'blyxxa_deploy_tool');
        data.append('filename', filename);
        data.append('content', content);
        data.append('nonce', '<?php echo esc_attr(wp_create_nonce('blyx_deploy_tool')); ?>');
        
        document.getElementById('deploy_res').style.display = 'none';
        
        fetch(ajaxurl, {method:'POST', body:data}).then(r=>r.json()).then(res => {
            // RESTORE STATE
            btn.innerHTML = originalText;
            btn.disabled = false;

            let d = document.getElementById('deploy_res');
            d.style.display = 'block';
            if(res.success) {
                d.innerHTML = '<div class="notice notice-success inline" style="padding:10px 15px; border-left-color:#10b981;"><p style="margin:0; font-size:14px;">✅ <strong>' + res.data.msg + '</strong><br><span style="font-family:monospace; background:#f1f5f9; padding:2px 6px; border-radius:4px; margin-top:5px; display:inline-block;">' + res.data.shortcode + '</span></p></div>';
            } else {
                d.innerHTML = '<div class="notice notice-error inline" style="padding:10px 15px;"><p style="margin:0;">❌ ' + res.data + '</p></div>';
            }
        }).catch(e => {
            btn.innerHTML = originalText;
            btn.disabled = false;
            Swal.fire({icon:'error', title:'<?php echo esc_js(__('Connection Error', 'blyxxa-core')); ?>', text:'Connection Error'});
        });
    }

    // --- LIBRARY LOGIC (SEARCH + PAGINATION) ---
    let libraryData = []; let libPage = 1; const libPerPage = 6;

    function saveProject() {
        let id = document.getElementById('t_id').value;
        if(!id) { 
            Swal.fire({
                icon: 'warning',
                title: '<?php echo esc_js(__('Missing ID', 'blyxxa-core')); ?>',
                text: '<?php echo esc_js(__('Tool ID is required to save project.', 'blyxxa-core')); ?>'
            });
            return; 
        }
        let project = {
            id: id,
            id: id,
            title: document.getElementById('t_title').value,
            cat: document.getElementById('t_cat').value,
            desc: document.getElementById('t_desc').value,
            role: document.getElementById('t_role').value,
            prompt: document.getElementById('t_prompt').value,
            inputs: inputs
        };
        let data = new FormData();
        data.append('action', 'blyxxa_lib_save');
        data.append('project', JSON.stringify(project));
        data.append('nonce', blyxConfig.nonces.save);
        fetch(ajaxurl, {method:'POST', body:data}).then(r=>r.json()).then(res => {
            if(res.success) {
                Swal.fire({
                    icon: 'success',
                    title: '<?php echo esc_js(__('Saved!', 'blyxxa-core')); ?>',
                    text: '<?php echo esc_js(__('Project Saved to Library!', 'blyxxa-core')); ?>',
                    timer: 1500,
                    showConfirmButton: false
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: '<?php echo esc_js(__('Error', 'blyxxa-core')); ?>',
                    text: '<?php echo esc_js(__('Error occurred.', 'blyxxa-core')); ?>'
                });
            }
        });
    }

    function openLibrary() {
        document.getElementById('blyx_lib_overlay').style.display = 'flex';
        document.getElementById('blyx_lib_list').innerHTML = '<div style="text-align:center; padding:20px; color:#666;">Veriler çekiliyor...</div>';
        
        let data = new FormData(); data.append('action', 'blyxxa_lib_get');
        data.append('nonce', blyxConfig.nonces.get);
        fetch(ajaxurl, {method:'POST', body:data}).then(r=>r.json()).then(res => {
            if(res.success) {
                libraryData = Object.values(res.data).reverse(); // Newest first
                libPage = 1;
                renderLibraryPage();
            } else {
                document.getElementById('blyx_lib_list').innerHTML = '<p style="text-align:center; color:#999;">Kütüphane boş.</p>';
            }
        });
    }

    function renderLibraryPage() {
        let search = document.getElementById('blyx_lib_search').value.toLowerCase();
        let filtered = libraryData.filter(p => 
            (p.id && p.id.toLowerCase().includes(search)) || 
            (p.title && p.title.toLowerCase().includes(search)) ||
            (p.cat && p.cat.toLowerCase().includes(search)) // CATEGORY SEARCH
        );
        let totalPages = Math.ceil(filtered.length / libPerPage);
        if (libPage > totalPages) libPage = totalPages > 0 ? totalPages : 1;
        if (libPage < 1) libPage = 1;

        let start = (libPage - 1) * libPerPage;
        let end = start + libPerPage;
        let pageItems = filtered.slice(start, end);

        let h = '';
        if(pageItems.length === 0) {
            h = '<div style="text-align:center; padding:20px; color:#999;">Sonuç bulunamadı.</div>';
        } else {
            pageItems.forEach(p => {
                let safeP = JSON.stringify(p).replace(/"/g, '&quot;');
                let catBadge = p.cat ? `<span style="color:#0369a1; background:#e0f2fe; border:1px solid #bae6fd;">${p.cat}</span>` : '';
                h += `<div class="blyx-lib-item">
                        <div class="blyx-lib-info">
                            <h4>${p.title || 'İsimsiz Araç'}</h4>
                            <div style="display:flex; gap:6px; margin-top:4px;">
                                <span>${p.id}</span>
                                ${catBadge}
                            </div>
                        </div>
                        <div class="blyx-lib-actions">
                            <button class="blyx-mini-btn" onclick="loadProject('${p.id}')">📂 Yükle</button>
                            <button class="blyx-mini-btn blyx-btn-del" onclick="deleteProject('${p.id}')">🗑 Sil</button>
                        </div>
                     </div>`;
            });
        }
        
        document.getElementById('blyx_lib_list').innerHTML = h;
        document.getElementById('lib_page_info').innerText = `Sayfa ${libPage} / ${totalPages || 1}`;
        document.getElementById('lib_prev').disabled = (libPage === 1);
        document.getElementById('lib_next').disabled = (libPage >= totalPages || totalPages === 0);
    }

    // Initialize Smart Import on Load
    document.addEventListener('DOMContentLoaded', function() {
        fetchModels();
    });

    function fetchModels() {
        var d = new FormData(); d.append('action', 'blyxxa_fetch_models');
        let s = document.getElementById('import_ai_model_select');
        if(!s) return;
        
        fetch(ajaxurl, {method:'POST',body:d}).then(r=>r.json()).then(j=>{
            s.innerHTML = ''; 
            let hasModels = false;
            
            // Helper to add options
            const addGroup = (label, models) => {
                if(models && models.length > 0) {
                    hasModels = true;
                    let g = document.createElement('optgroup'); g.label = label;
                    models.forEach(m => {
                        let txt = m.name || m.id; 
                        g.appendChild(new Option(txt, m.id));
                    });
                    s.appendChild(g);
                }
            };

            addGroup('Google Gemini', j.data.google);
            addGroup('OpenAI', j.data.openai);
            addGroup('Anthropic Claude', j.data.anthropic);
            addGroup('Perplexity', j.data.perplexity);
            addGroup('Groq (Fast)', j.data.groq);
            addGroup('OpenRouter', j.data.openrouter);

            if(!hasModels) {
                s.innerHTML = '<option disabled>⚠️ <?php echo esc_js(__('No API Keys Found', 'blyxxa-core')); ?></option>';
            }
        });
    }

    // --- ADVANCED CATEGORY MANAGER UI ---
    function fetchCats(selectVal = '') {
        let s = document.getElementById('t_cat');
        let d = new FormData(); d.append('action', 'blyxxa_manage_cats'); d.append('mode', 'get');
        d.append('nonce', blyxConfig.nonces.cats);
        
        fetch(ajaxurl, {method:'POST', body:d}).then(r=>r.json()).then(res => {
            if(res.success) {
                s.innerHTML = '<option value="">-- <?php echo esc_js(__('Select Category', 'blyxxa-core')); ?> --</option>';
                res.data.forEach(c => {
                    let opt = new Option(c, c);
                    if(c === selectVal) opt.selected = true;
                    s.appendChild(opt);
                });
            }
        });
    }

    function openCatManager() {
        document.getElementById('blyx_cat_manager').style.display = 'flex';
        loadCatList();
    }

    function closeCatManager() {
        document.getElementById('blyx_cat_manager').style.display = 'none';
    }

    function loadCatList() {
        let c = document.getElementById('cat_list_container');
        c.innerHTML = '<div style="text-align:center; color:#94a3b8;">Loading...</div>';
        
        let d = new FormData(); d.append('action', 'blyxxa_manage_cats'); d.append('mode', 'get');
        d.append('nonce', blyxConfig.nonces.cats);
        fetch(ajaxurl, {method:'POST', body:d}).then(r=>r.json()).then(res => {
            if(res.success) {
                let h = '<ul style="list-style:none; padding:0; margin:0;">';
                res.data.forEach(cat => {
                    h += `<li style="display:flex; justify-content:space-between; align-items:center; padding:10px; border-bottom:1px solid #f1f5f9;">
                            <span style="font-weight:600; color:#334155;">${cat}</span>
                            <div style="display:flex; gap:5px;">
                                <button onclick="editCat('${cat}')" class="blyx-mini-btn" title="Edit">✏️</button>
                                <button onclick="delCat('${cat}')" class="blyx-mini-btn blyx-btn-del" title="Delete">🗑</button>
                            </div>
                          </li>`;
                });
                h += '</ul>';
                c.innerHTML = h;
            }
        });
    }

    function manageCat(mode, oldCat = '') {
        let d = new FormData(); d.append('action', 'blyxxa_manage_cats'); d.append('mode', mode);
        d.append('nonce', blyxConfig.nonces.cats);
        
        if(mode === 'add') {
            let val = document.getElementById('new_cat_input').value;
            if(!val) return;
            d.append('cat', val);
        } else if(mode === 'edit') {
            let newName = prompt('<?php echo esc_js(__('Rename Category:', 'blyxxa-core')); ?>', oldCat);
            if(!newName || newName === oldCat) return;
            d.append('old_cat', oldCat);
            d.append('new_cat', newName);
        } else if(mode === 'del') {
            if(!confirm('<?php echo esc_js(__('Delete this category? Tools in this category will become Uncategorized.', 'blyxxa-core')); ?>')) return;
            d.append('cat', oldCat);
        }

        fetch(ajaxurl, {method:'POST', body:d}).then(r=>r.json()).then(res => {
            if(res.success) {
                if(mode === 'add') document.getElementById('new_cat_input').value = '';
                loadCatList(); // Refresh list
                fetchCats(); // Refresh main dropdown
            } else {
                Swal.fire({icon: 'error', title: '<?php echo esc_js(__('Error', 'blyxxa-core')); ?>', text: res.data});
            }
        });
    }

    function editCat(c) { manageCat('edit', c); }
    function delCat(c) { manageCat('del', c); }

    // Init Cats & Edit Mode
    document.addEventListener('DOMContentLoaded', function() {
        console.log('Factory Loaded. Edit Data:', editData);
        
        if(editData) {
            console.log('Edit Mode Detected. Locking ID.');
            let tidInput = document.getElementById('t_id');
            if(tidInput) {
                tidInput.value = editData.id;
                tidInput.readOnly = true; // LOCK ID FOR EDIT MODE
                tidInput.style.backgroundColor = '#f1f5f9';
                tidInput.style.cursor = 'not-allowed';
            }

            // FORCE SHOW GENERATE BUTTON IN EDIT MODE
            let btnGen = document.getElementById('btn_generate_tool');
            let btnLim = document.getElementById('btn_limit_reached');
            if(btnGen) btnGen.style.display = 'flex';
            if(btnLim) btnLim.style.display = 'none';

            document.getElementById('t_title').value = editData.title;
            // Pass category to fetchCats to handle async loading
            fetchCats(editData.cat || '');
            document.getElementById('t_desc').value = editData.desc;
            document.getElementById('t_role').value = editData.role;
            document.getElementById('t_prompt').value = editData.prompt;
            inputs = editData.inputs || [];
            render();
            window.scrollTo(0,0);
        } else if ('<?php echo esc_js($edit_id); ?>' !== '') {
            Swal.fire({
                title: '<?php echo esc_js(__('Project Not Found', 'blyxxa-core')); ?>',
                html: '<?php echo esc_js(__('Project file not found in library.', 'blyxxa-core') . '<br><br>' . __('Only tools created with "Tool Factory" and saved to the library can be edited.', 'blyxxa-core')); ?>',
                icon: 'error',
                confirmButtonColor: '#06b6d4'
            });
            fetchCats();
        } else {
            fetchCats();
        }
    });

    function parseImport() {
        let text = document.getElementById('import_text').value;
        let s = document.getElementById('import_ai_model_select');
        let model = s ? s.value : '';
        
        if(!text) { 
            Swal.fire({
                icon: 'info',
                title: '<?php echo esc_js(__('Describe your tool', 'blyxxa-core')); ?>',
                text: '<?php echo esc_js(__('Please describe your tool first.', 'blyxxa-core')); ?>'
            });
            return; 
        }
        if(!model) { 
            Swal.fire({
                icon: 'warning',
                title: '<?php echo esc_js(__('Missing Model', 'blyxxa-core')); ?>',
                text: '<?php echo esc_js(__('Please select an AI model.', 'blyxxa-core')); ?>'
            });
            return; 
        }

        let btn = document.getElementById('btn_import_action');
        let originalText = btn.innerHTML;
        btn.innerHTML = '⏳ <?php echo esc_js(__('Architecting Tool...', 'blyxxa-core')); ?>';
        btn.disabled = true;
        
        let data = new FormData();
        data.append('action', 'blyxxa_ai_import');
        data.append('desc', text); // Changed from 'text' to 'desc' to match PHP handler
        data.append('model', model);
        data.append('nonce', '<?php echo esc_attr(wp_create_nonce('blyx_import_ai')); ?>'); // Correct nonce name
        
        fetch(ajaxurl, {method:'POST', body:data}).then(r=>r.json()).then(res => {
            btn.innerHTML = originalText;
            btn.disabled = false;
            
            if(res.success) {
                let d = res.data.json; 
                
                // Fallback: Try to parse raw string if server failed to decode
                if(!d && res.data.raw) {
                    try {
                        // Clean markdown code blocks if present in raw string
                        let raw = res.data.raw;
                        if(raw.includes('```json')) {
                            raw = raw.split('```json')[1].split('```')[0];
                        } else if(raw.includes('```')) {
                            raw = raw.split('```')[1].split('```')[0];
                        }
                        d = JSON.parse(raw);
                    } catch(e) {
                        console.error('JSON Parse Error:', e);
                        Swal.fire({
                            icon: 'error',
                            title: '<?php echo esc_js(__('Parsing Error', 'blyxxa-core')); ?>',
                            text: 'AI Response Parsing Failed. Raw: ' + res.data.raw.substring(0, 100) + '...'
                        });
                        return;
                    }
                }

                if(!d) {
                    // If still no data, maybe it's in res.data directly (legacy)
                    d = res.data;
                }

                if(!d || (!d.title && !d.tool_name)) {
                     let rawPreview = res.data.raw ? res.data.raw.substring(0, 200) : 'No raw data';
                     Swal.fire({
                        icon: 'error',
                        title: '<?php echo esc_js(__('Invalid Format', 'blyxxa-core')); ?>',
                        text: '<?php echo esc_js(__('AI generated an invalid response format.', 'blyxxa-core')); ?>\n\nDebug: ' + rawPreview + '...'
                     });
                     console.log('Invalid Data:', d);
                     return;
                }

                document.getElementById('t_title').value = d.title || d.tool_name || '';
                let tid = d.id || d.tool_id || (d.title ? d.title.toLowerCase().replace(/[^a-z0-9]/g, '_') : '');
                document.getElementById('t_id').value = tid.substring(0, 20);
                document.getElementById('t_cat').value = d.category || d.cat || '';
                document.getElementById('t_desc').value = d.desc || d.description || '';
                document.getElementById('t_prompt').value = d.prompt || d.system_prompt || '';
                
                if(d.inputs && Array.isArray(d.inputs)) {
                    inputs = d.inputs.map(i => {
                        return {
                            type: i.type,
                            name: i.name,
                            label: i.label,
                            ph: i.placeholder || i.ph || '',
                            opts: i.options || i.opts || '',
                            chk_val: i.value || i.chk_val || ''
                        };
                    });
                } else if(d.parameters && Array.isArray(d.parameters)) {
                    inputs = d.parameters.map(i => {
                        return {
                            type: i.type,
                            name: i.name,
                            label: i.label,
                            ph: i.placeholder || i.ph || '',
                            opts: i.options || i.opts || '',
                            chk_val: i.value || i.chk_val || ''
                        };
                    });
                }

                // Map Role if present
                document.getElementById('t_role').value = d.role || '';
                
                render();
                Swal.fire({
                    icon: 'success',
                    title: '<?php echo esc_js(__('Magic Happened! ✨', 'blyxxa-core')); ?>',
                    text: '<?php echo esc_js(__('Tool structure generated from your description.', 'blyxxa-core')); ?>',
                    timer: 1500,
                    showConfirmButton: false
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: '<?php echo esc_js(__('Generation Error', 'blyxxa-core')); ?>',
                    text: (res.data.message || res.data || 'Unknown Error')
                });
            }
        }).catch(e => {
            btn.innerHTML = originalText;
            btn.disabled = false;
            Swal.fire({
                icon: 'error',
                title: '<?php echo esc_js(__('Connection Error', 'blyxxa-core')); ?>',
                text: e.message
            });
        });
    }

    function changeLibPage(step) { libPage += step; renderLibraryPage(); }

    function loadProject(id) {
        let p = libraryData.find(item => item.id === id);
        if(!p) { 
            Swal.fire({icon:'error', title:'<?php echo esc_js(__('Project Not Found', 'blyxxa-core')); ?>', text: '<?php echo esc_js(__('Project data not found!', 'blyxxa-core')); ?>'}); 
            return; 
        }
        
        Swal.fire({
            title: '<?php echo esc_js(__('Load Project?', 'blyxxa-core')); ?>',
            text: '<?php echo esc_js(__('Do you want to clear current form and load tool', 'blyxxa-core')); ?> "' + (p.title || p.id) + '"?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#06b6d4',
            cancelButtonColor: '#64748b',
            confirmButtonText: '<?php echo esc_js(__('Yes, load it!', 'blyxxa-core')); ?>',
            cancelButtonText: '<?php echo esc_js(__('Cancel', 'blyxxa-core')); ?>'
        }).then((result) => {
            if (result.isConfirmed) {
                let tidInput = document.getElementById('t_id');
                tidInput.value = p.id;
                tidInput.readOnly = true; // LOCK ID
                tidInput.style.backgroundColor = '#f1f5f9'; // VISUAL CUE
                tidInput.style.cursor = 'not-allowed';

                // FORCE SHOW GENERATE BUTTON FOR EXISTING PROJECT
                let btnGen = document.getElementById('btn_generate_tool');
                let btnLim = document.getElementById('btn_limit_reached');
                if(btnGen) btnGen.style.display = 'flex';
                if(btnLim) btnLim.style.display = 'none';

                document.getElementById('t_title').value = p.title;
                document.getElementById('t_cat').value = p.cat || '';
                document.getElementById('t_desc').value = p.desc;
                document.getElementById('t_role').value = p.role;
                document.getElementById('t_prompt').value = p.prompt;
                inputs = p.inputs || [];
                render();
                document.getElementById('blyx_lib_overlay').style.display = 'none';
                
                Swal.fire({
                    icon: 'success',
                    title: '<?php echo esc_js(__('Loaded!', 'blyxxa-core')); ?>',
                    timer: 1500,
                    showConfirmButton: false
                });
            }
        });
    }

    function deleteProject(id) {
        Swal.fire({
            title: '<?php echo esc_js(__('Are you sure?', 'blyxxa-core')); ?>',
            text: '<?php echo esc_js(__('Do you want to delete this project? This will also delete the deployed tool file!', 'blyxxa-core')); ?>',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: '<?php echo esc_js(__('Yes, delete it!', 'blyxxa-core')); ?>',
            cancelButtonText: '<?php echo esc_js(__('Cancel', 'blyxxa-core')); ?>'
        }).then((result) => {
            if (result.isConfirmed) {
                let data = new FormData();
                data.append('action', 'blyxxa_lib_del');
                data.append('id', id);
                data.append('nonce', blyxConfig.nonces.del);
                fetch(ajaxurl, {method:'POST', body:data}).then(r=>r.json()).then(res => {
                    libraryData = libraryData.filter(p => p.id !== id);
                    renderLibraryPage();
                    Swal.fire(
                        '<?php echo esc_js(__('Deleted!', 'blyxxa-core')); ?>',
                        '<?php echo esc_js(__('Project and file have been deleted.', 'blyxxa-core')); ?>',
                        'success'
                    );
                });
            }
        });
    }
    </script>
    <?php
}

// --- LIBRARY BACKEND ACTIONS ---
add_action('wp_ajax_blyxxa_lib_save', function() {
    check_ajax_referer('blyx_lib_save', 'nonce');
    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
    $p_json = isset($_POST['project']) ? wp_unslash($_POST['project']) : ''; // JSON string
    $p = json_decode($p_json, true);
    if(!$p || !$p['id']) wp_send_json_error();
    $lib = get_option('blyxxa_tool_library', []);
    $lib[$p['id']] = $p;
    update_option('blyxxa_tool_library', $lib);
    wp_send_json_success();
});

add_action('wp_ajax_blyxxa_lib_get', function() {
    check_ajax_referer('blyx_lib_get', 'nonce');
    $lib = get_option('blyxxa_tool_library', []);
    $changed = false;
    
    // 1. FULL SYNC: Rebuild Library from Physical Files (Source of Truth)
    $files = glob(BLYXXA_TOOLS_PATH . '*.php');
    if($files) {
        foreach($files as $file) {
            $slug = basename($file, '.php');
            
            // Allow override/repair if ID doesn't match or entry missing
            $needs_repair = !isset($lib[$slug]) || ($lib[$slug]['id'] !== $slug);
            
            if($needs_repair) {
                $f_content = file_get_contents($file);
                $parts = explode('// Include Master Template', $f_content);
                if(count($parts) > 1) {
                    $raw_config = $parts[0];
                    $raw_config = preg_replace('/^\s*<\?php.*\$tool_config\s*=\s*/s', '', $raw_config);
                    $raw_config = trim($raw_config);
                    if(substr($raw_config, -1) === ';') $raw_config = substr($raw_config, 0, -1);
                    
                    try {
                        $recovered = eval('return ' . $raw_config . ';');
                        if(is_array($recovered)) {
                            // FORCE CONSISTENCY: ID must match Filename
                            $recovered['id'] = $slug;
                            $lib[$slug] = $recovered;
                            $changed = true;
                        }
                    } catch(Exception $e) {}
                }
            }
        }
    }
    
    // 2. CLEANUP: Remove library entries that have NO file
    foreach($lib as $id => $data) {
        $file = BLYXXA_TOOLS_PATH . sanitize_file_name($id) . '.php';
        if(!file_exists($file)) {
            unset($lib[$id]);
            $changed = true;
        }
    }
    
    if($changed) {
        update_option('blyxxa_tool_library', $lib);
    }
    
    wp_send_json_success($lib);
});

add_action('wp_ajax_blyxxa_lib_del', function() {
    check_ajax_referer('blyx_lib_del', 'nonce');
    $id = isset($_POST['id']) ? sanitize_text_field(wp_unslash($_POST['id'])) : '';
    $lib = get_option('blyxxa_tool_library', []);
    if(isset($lib[$id])) { 
        unset($lib[$id]); 
        update_option('blyxxa_tool_library', $lib); 
        
        // SYNC: Delete Physical File
        $file = BLYXXA_TOOLS_PATH . sanitize_file_name($id) . '.php';
        if(file_exists($file)) wp_delete_file($file);
    }
    wp_send_json_success();
});

// --- ADVANCED CATEGORY MANAGER ---
add_action('wp_ajax_blyxxa_manage_cats', function() {
    // Security Check
    check_ajax_referer('blyx_manage_cats', 'nonce');
    if(!current_user_can('manage_options')) wp_send_json_error(__('Permission denied.', 'blyxxa-core'));
    
    $mode = isset($_POST['mode']) ? sanitize_text_field(wp_unslash($_POST['mode'])) : ''; // get, add, edit, del
    $cats = get_option('blyxxa_categories', ['General', 'Social Media', 'SEO', 'Copywriting', 'Email Marketing']);
    
    if($mode === 'get') {
        wp_send_json_success($cats);
    }
    
    if($mode === 'add') {
        $c = isset($_POST['cat']) ? sanitize_text_field(wp_unslash($_POST['cat'])) : '';
        if(!$c) wp_send_json_error(__('Invalid name.', 'blyxxa-core'));
        if(!in_array($c, $cats)) {
            $cats[] = $c;
            update_option('blyxxa_categories', $cats);
        }
        wp_send_json_success($cats);
    }

    if($mode === 'edit') {
        $old = isset($_POST['old_cat']) ? sanitize_text_field(wp_unslash($_POST['old_cat'])) : '';
        $new = isset($_POST['new_cat']) ? sanitize_text_field(wp_unslash($_POST['new_cat'])) : '';
        if(!$old || !$new) wp_send_json_error(__('Invalid data.', 'blyxxa-core'));
        
        // Update List
        $key = array_search($old, $cats);
        if($key !== false) {
            $cats[$key] = $new;
            update_option('blyxxa_categories', $cats);
            
            // UPDATE TOOL FILES
            $files = glob(BLYXXA_TOOLS_PATH . '*.php');
            foreach($files as $file) {
                $content = file_get_contents($file);
                // Regex to find "Category: OldName" in header
                // We look for " * Category: OldName" (with optional spaces)
                $pattern = '/(\*\s*Category:\s*)' . preg_quote($old, '/') . '(\s*[\r\n])/i';
                if(preg_match($pattern, $content)) {
                    $new_content = preg_replace($pattern, '${1}' . $new . '${2}', $content);
                    file_put_contents($file, $new_content);
                }
            }
        }
        wp_send_json_success($cats);
    }

    if($mode === 'del') {
        $del = isset($_POST['cat']) ? sanitize_text_field(wp_unslash($_POST['cat'])) : '';
        if(!$del) wp_send_json_error(__('Invalid data.', 'blyxxa-core'));
        
        $key = array_search($del, $cats);
        if($key !== false) {
            unset($cats[$key]);
            update_option('blyxxa_categories', array_values($cats)); // Re-index
            
            // UPDATE TOOL FILES (Set to empty)
            $files = glob(BLYXXA_TOOLS_PATH . '*.php');
            foreach($files as $file) {
                $content = file_get_contents($file);
                $pattern = '/(\*\s*Category:\s*)' . preg_quote($del, '/') . '(\s*[\r\n])/i';
                if(preg_match($pattern, $content)) {
                    $new_content = preg_replace($pattern, '${1}' . '' . '${2}', $content); // Set to empty
                    file_put_contents($file, $new_content);
                }
            }
        }
        wp_send_json_success($cats);
    }
    
    wp_send_json_error(__('Invalid mode.', 'blyxxa-core'));
});

add_action('wp_ajax_blyxxa_deploy_tool', function() {
    check_ajax_referer('blyx_deploy_tool', 'nonce');
    if(!current_user_can('manage_options')) wp_send_json_error(__('Permission denied.', 'blyxxa-core'));
    
    $filename = isset($_POST['filename']) ? sanitize_title(wp_unslash($_POST['filename'])) : '';
    if(!$filename) wp_send_json_error(__('Invalid filename.', 'blyxxa-core'));
    $filename .= '.php';
    if (substr($filename, -4) !== '.php') $filename .= '.php';
    
    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
    $content = isset($_POST['content']) ? stripslashes(wp_unslash($_POST['content'])) : '';
    if (strpos(trim($content), '<?php') !== 0) $content = "<?php\n" . $content;
    
    if (!is_dir(BLYXXA_TOOLS_PATH)) wp_mkdir_p(BLYXXA_TOOLS_PATH);
    
    if (file_put_contents(BLYXXA_TOOLS_PATH . $filename, $content)) {
        $slug = str_replace('.php', '', $filename);
        $shortcode = '[tool_'.$slug.']';
        wp_send_json_success(['msg' => __('Tool deployed successfully!', 'blyxxa-core'), 'shortcode' => $shortcode]);
    } else {
        wp_send_json_error(__('Failed to write file. Check permissions.', 'blyxxa-core'));
    }
});

add_action('wp_ajax_blyxxa_ai_import', function() {
    check_ajax_referer('blyx_ai_imp', 'nonce');
    if(!current_user_can('manage_options')) wp_send_json_error('Unauthorized');
    
    $text = isset($_POST['text']) ? sanitize_textarea_field(wp_unslash($_POST['text'])) : '';
    $model = isset($_POST['model']) ? sanitize_text_field(wp_unslash($_POST['model'])) : 'gemini';
    
    // REMOTE MASTER PROMPT FETCH (CLIENT MODE)
    $remote_prompt = get_transient('blyxxa_cached_master_prompt');
    
    // Fallback if remote fetch failed or not yet cached
    $fallback_prompt = "You are a Tool Configuration Architect. Analyze the following text and extract tool configuration.
    Return ONLY a valid JSON object with this structure:
    {
        \"title\": \"Tool Name\",
        \"id\": \"tool_id_snake_case\",
        \"category\": \"Category Name (e.g. SEO, Social Media)\",\n    \"desc\": \"Short description\",\n    \"prompt\": \"The full prompt text (keep original text)\",
        \"inputs\": [
            { \"type\": \"text|textarea|select|number|checkbox\", \"name\": \"var_name\", \"label\": \"Label\", \"ph\": \"Placeholder\", \"opts\": \"Option1\\nOption2\" (if select), \"chk_val\": \"Value\" (if checkbox) }
        ]
    }
    
    Rules:
    1. Detect variables in text like {var} and create inputs for them.
    2. Guess input types based on context (e.g., 'list' -> select, 'content' -> textarea).
    3. Do not include markdown formatting in JSON.
    4. Return ONLY JSON.";

    $system_prompt = !empty($remote_prompt) ? $remote_prompt : $fallback_prompt;
    
    $final_prompt = $system_prompt . "\n\nTEXT TO ANALYZE:\n" . $text;
    
    // Use Universal API Call (Handles all providers: OpenAI, Gemini, Claude, Perplexity, OpenRouter)
    if (!function_exists('blyxxa_universal_api_call')) {
        require_once BLYXXA_CORE_PATH . 'includes/blyxxa-api-handler.php';
    }
    
    $res = blyxxa_universal_api_call($model, $final_prompt);
    
    if($res['success']) {
        // Clean JSON
        $res_content = str_replace(['```json', '```'], '', $res['data']);
        $json = json_decode($res_content, true);
        
        if($json) {
            wp_send_json_success($json);
        } else {
            wp_send_json_error('Failed to parse AI response: ' . $res_content);
        }
    } else {
        wp_send_json_error($res['msg']);
    }
});

// BACKEND PROCESSOR (v27 - Modular Config Generator)
// BACKEND PROCESSOR (v27 - Modular Config Generator)
add_action('wp_ajax_blyxxa_gen_v27_process', function() {
    check_ajax_referer('blyx_gen_process', 'nonce');
    if(!current_user_can('manage_options')) wp_send_json_error('Unauthorized');

    $id = isset($_POST['id']) ? sanitize_text_field(wp_unslash($_POST['id'])) : ''; // Get ID early for file check

    // SERVER-SIDE LIMIT CHECK
    $is_premium = (class_exists('Blyxxa_Client_License') && Blyxxa_Client_License::get_license_status() === 'active');
    
    // Check if this is an UPDATE (File exists)
    $target_file = BLYXXA_TOOLS_PATH . $id . '.php';
    $is_update = file_exists($target_file);
    
    if (!$is_premium && !$is_update) {
        // Only enforce limit for NEW tools for free users
        $tool_count = count(glob(BLYXXA_TOOLS_PATH . '*.php'));
        if ($tool_count >= 1) {
            wp_send_json_error(__('Free Plan Limit Reached. Please upgrade to create more tools.', 'blyxxa-core'));
        }
    }

    $title = isset($_POST['title']) ? sanitize_text_field(wp_unslash($_POST['title'])) : '';
    $cat = isset($_POST['cat']) ? sanitize_text_field(wp_unslash($_POST['cat'])) : '';
    $desc = isset($_POST['desc']) ? sanitize_text_field(wp_unslash($_POST['desc'])) : '';
    $role = isset($_POST['role']) ? sanitize_text_field(wp_unslash($_POST['role'])) : '';
    $raw_prompt = isset($_POST['prompt']) ? wp_kses_post(wp_unslash($_POST['prompt'])) : ''; 
    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
    $project = isset($_POST['project']) ? json_decode(wp_unslash($_POST['project']), true) : [];
    if (!is_array($project)) $project = [];
    
    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
    $inputs = isset($_POST['inputs']) ? json_decode(wp_unslash($_POST['inputs']), true) : [];
    if (!is_array($inputs)) $inputs = [];
    
    // AUTO-SAVE TO LIBRARY
    $lib = get_option('blyxxa_tool_library', []);
    if (!is_array($lib)) $lib = []; // Safety check

    $lib[$id] = [
        'id' => $id,
        'title' => $title,
        'cat' => $cat,
        'desc' => $desc,
        'role' => $role,
        'prompt' => $raw_prompt,
        'inputs' => $inputs
    ];
    update_option('blyxxa_tool_library', $lib);

    // GENERATE PHP CODE (Modular Config)
    // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_var_export
    $config_array = var_export([
        'id' => $id,
        'title' => $title,
        'desc' => $desc,
        'prompt' => $raw_prompt,
        'role' => $role,
        'inputs' => $inputs
    ], true);

    $php_code = "<?php\n";
    $php_code .= "/*\n";
    $php_code .= " * Tool ID: $id\n";
    $php_code .= " * Title: $title\n";
    $php_code .= " * Category: $cat\n";
    $php_code .= " * Role: $role\n";
    $php_code .= " * Description: $desc\n";
    $php_code .= " */\n\n";
    $php_code .= "if ( ! defined( 'ABSPATH' ) ) exit;\n\n";
    $php_code .= '$blyxxa_tool_config = ' . $config_array . ";\n\n";
    $php_code .= "// Include Master Template\n";
    $php_code .= "require BLYXXA_CORE_PATH . 'includes/tool-template.php';\n";

    wp_send_json_success([
        'code' => $php_code,
        'shortcode' => "[tool_$id]"
    ]);
});