<?php
if (! defined('WP_DEBUG')) {
	die( 'Direct access forbidden.' );
}
add_action( 'wp_enqueue_scripts', function () {
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
});

/*
 * BLYXXA CORE - MENU LOGIC (NATIVE)
 * Blocksy Child functions.php içine eklendi.
 */
add_filter('wp_nav_menu_objects', 'blyxxa_native_menu_filter', 10, 2);

function blyxxa_native_menu_filter($items, $args) {
    
    // Admin panelinde veya düzenleme modunda menüler kaybolmasın
    if (is_admin()) return $items;

    $user_logged_in = is_user_logged_in();
    $is_admin = current_user_can('administrator');

    foreach ($items as $key => $item) {
        // Menü öğesinin CSS sınıflarını al
        $classes = $item->classes;

        // 1. only-guest: Sadece giriş YAPMAMIŞLAR görür (Login vb.)
        if (in_array('only-guest', $classes)) {
            if ($user_logged_in) {
                unset($items[$key]);
                continue;
            }
        }

        // 2. only-member: Sadece giriş YAPMIŞLAR görür (Profil vb.)
        if (in_array('only-member', $classes)) {
            if (!$user_logged_in) {
                unset($items[$key]);
                continue;
            }
        }

        // 3. only-admin: Sadece YÖNETİCİLER görür
        if (in_array('only-admin', $classes)) {
            if (!$is_admin) {
                unset($items[$key]);
                continue;
            }
        }

        // 4. #logout: Otomatik güvenli çıkış linki
        if ($item->url === '#logout') {
            $item->url = wp_logout_url(home_url());
        }
    }

    return $items;
}