<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Blyxxa Module Loader (Client)
 * 
 * This file is responsible for loading isolated feature modules for the client.
 */

class Blyxxa_Client_Module_Loader {

    private static $modules_path;

    public static function init() {
        self::$modules_path = plugin_dir_path( __FILE__ ) . 'modules/';
        
        // Auto-load all active modules
        self::load_modules();
    }

    private static function load_modules() {
        // List of active modules
        $active_modules = [
            'pwa', // Active
            // 'theme-engine' // Coming soon
        ];

        foreach ( $active_modules as $module ) {
            $file = self::$modules_path . $module . '/loader.php';
            if ( file_exists( $file ) ) {
                require_once $file;
            }
        }
    }
}

// Initialize Loader
Blyxxa_Client_Module_Loader::init();
