<?php
// BLYXXA PWA MANAGER
// Handles PWA Settings, Manifest Generation, and Service Worker Configuration

function blyxxa_pwa_manager_page() {
    wp_enqueue_media(); // Enqueue WP Media Uploader scripts
    // Save Settings
    if (isset($_POST['blyxxa_save_pwa']) && check_admin_referer('blyx_pwa_save')) {
        // General
        update_option('blyxxa_pwa_name', isset($_POST['blyxxa_pwa_name']) ? sanitize_text_field(wp_unslash($_POST['blyxxa_pwa_name'])) : '');
        update_option('blyxxa_pwa_short_name', isset($_POST['blyxxa_pwa_short_name']) ? sanitize_text_field(wp_unslash($_POST['blyxxa_pwa_short_name'])) : '');
        update_option('blyxxa_pwa_description', isset($_POST['blyxxa_pwa_description']) ? sanitize_textarea_field(wp_unslash($_POST['blyxxa_pwa_description'])) : '');
        update_option('blyxxa_pwa_start_url', isset($_POST['blyxxa_pwa_start_url']) ? sanitize_text_field(wp_unslash($_POST['blyxxa_pwa_start_url'])) : '');
        
        // AssetLinks (Play Store)
        update_option('blyxxa_pwa_assetlinks_package', isset($_POST['blyxxa_pwa_assetlinks_package']) ? sanitize_text_field(wp_unslash($_POST['blyxxa_pwa_assetlinks_package'])) : '');
        update_option('blyxxa_pwa_assetlinks_sha256', isset($_POST['blyxxa_pwa_assetlinks_sha256']) ? sanitize_textarea_field(wp_unslash($_POST['blyxxa_pwa_assetlinks_sha256'])) : '');
        
        // Branding
        update_option('blyxxa_pwa_icon', isset($_POST['blyxxa_pwa_icon']) ? sanitize_url(wp_unslash($_POST['blyxxa_pwa_icon'])) : '');
        update_option('blyxxa_pwa_splash_icon', isset($_POST['blyxxa_pwa_splash_icon']) ? sanitize_url(wp_unslash($_POST['blyxxa_pwa_splash_icon'])) : ''); // Splash Screen Icon
        update_option('blyxxa_pwa_default_tool_icon', isset($_POST['blyxxa_pwa_default_tool_icon']) ? sanitize_url(wp_unslash($_POST['blyxxa_pwa_default_tool_icon'])) : ''); // Default Tool Icon
        update_option('blyxxa_pwa_theme_color', isset($_POST['blyxxa_pwa_theme_color']) ? sanitize_hex_color(wp_unslash($_POST['blyxxa_pwa_theme_color'])) : '');
        update_option('blyxxa_pwa_bg_color', isset($_POST['blyxxa_pwa_bg_color']) ? sanitize_hex_color(wp_unslash($_POST['blyxxa_pwa_bg_color'])) : '');
        
        // iOS Settings
        update_option('blyxxa_pwa_ios_status', isset($_POST['blyxxa_pwa_ios_status']) ? '1' : '0');

        // Flush Rewrite Rules (for AssetLinks)
        flush_rewrite_rules();

        echo '<div class="notice notice-success is-dismissible"><p>✅ ' . esc_html__('PWA Settings Saved!', 'blyxxa-core') . '</p></div>';
    }

    // Get Options
    $pwa_name = get_option('blyxxa_pwa_name', get_bloginfo('name'));
    $pwa_short_name = get_option('blyxxa_pwa_short_name', substr(get_bloginfo('name'), 0, 12));
    $pwa_desc = get_option('blyxxa_pwa_description', get_bloginfo('description'));
    $pwa_start_url = get_option('blyxxa_pwa_start_url', home_url());
    
    // AssetLinks Options
    $pwa_package = get_option('blyxxa_pwa_assetlinks_package', '');
    $pwa_sha256 = get_option('blyxxa_pwa_assetlinks_sha256', '');
    
    $pwa_icon = get_option('blyxxa_pwa_icon', '');
    if(empty($pwa_icon)) {
        $pwa_icon = get_site_icon_url(512);
    }
    $pwa_splash_icon = get_option('blyxxa_pwa_splash_icon', '');
    $pwa_default_tool_icon = get_option('blyxxa_pwa_default_tool_icon', '');
    $pwa_theme_color = get_option('blyxxa_pwa_theme_color', '#0f172a');
    $pwa_bg_color = get_option('blyxxa_pwa_bg_color', '#ffffff');
    
    $ios_status = get_option('blyxxa_pwa_ios_status', '1');
    ?>
    <style>
        /* Fix Admin Notice Visibility */
        .notice, .updated, .error { color: #333 !important; }
        .notice p, .updated p, .error p { color: #333 !important; }
    </style>

    <div class="blyx-card blyx-full-card">
        <h3>📱 <?php esc_html_e('PWA Configuration', 'blyxxa-core'); ?></h3>
        <p style="color:#64748b; margin-bottom:20px;">
            <?php esc_html_e('Turn your SaaS into a mobile app. These settings control how your app looks when installed on a user\'s device.', 'blyxxa-core'); ?>
        </p>

        <form method="post" action="">
            <?php wp_nonce_field('blyx_pwa_save'); ?>
            
            <div style="display:grid; grid-template-columns: 1fr 1fr; gap:30px;">
                
                <!-- LEFT COLUMN: GENERAL -->
                <div>
                    <h4 style="margin-top:0; color:#334155; border-bottom:1px solid #e2e8f0; padding-bottom:10px;"><?php esc_html_e('App Identity', 'blyxxa-core'); ?></h4>
                    
                    <div style="margin-bottom:15px;">
                        <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('App Name', 'blyxxa-core'); ?></label>
                        <input type="text" name="blyxxa_pwa_name" value="<?php echo esc_attr($pwa_name); ?>" class="widefat" placeholder="My SaaS App">
                        <p class="description"><?php esc_html_e('The full name of your application.', 'blyxxa-core'); ?></p>
                    </div>

                    <div style="margin-bottom:15px;">
                        <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Short Name', 'blyxxa-core'); ?></label>
                        <input type="text" name="blyxxa_pwa_short_name" value="<?php echo esc_attr($pwa_short_name); ?>" class="widefat" maxlength="12" placeholder="MySaaS">
                        <p class="description"><?php esc_html_e('Displayed on the home screen (max 12 chars).', 'blyxxa-core'); ?></p>
                    </div>

                    <div style="margin-bottom:15px;">
                        <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Description', 'blyxxa-core'); ?></label>
                        <textarea name="blyxxa_pwa_description" class="widefat" rows="3"><?php echo esc_textarea($pwa_desc); ?></textarea>
                    </div>

                    <div style="margin-bottom:15px;">
                        <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Start URL', 'blyxxa-core'); ?></label>
                        <input type="url" name="blyxxa_pwa_start_url" value="<?php echo esc_url($pwa_start_url); ?>" class="widefat">
                        <p class="description"><?php esc_html_e('Where the app should start when launched (usually your Dashboard or Login page).', 'blyxxa-core'); ?></p>
                    </div>

                    
                    <h4 style="margin-top:30px; color:#334155; border-bottom:1px solid #e2e8f0; padding-bottom:10px;">
                        <?php esc_html_e('Play Store Verification (AssetLinks)', 'blyxxa-core'); ?> 
                        <span style="font-size:11px; background:#0f172a; color:#fff; padding:2px 6px; border-radius:4px; vertical-align:middle; margin-left:5px;">PRO</span>
                    </h4>
                    
                    <?php 
                    $sub_status = get_option('blyxxa_client_sub_status', []);
                    $is_premium = isset($sub_status['status']) && $sub_status['status'] === 'active';
                    $blur_style = !$is_premium ? 'filter: blur(4px); pointer-events: none; opacity: 0.5;' : '';
                    ?>

                    <div style="position:relative;">
                        <?php if(!$is_premium): ?>
                            <div style="position:absolute; top:0; left:0; width:100%; height:100%; z-index:10; display:flex; flex-direction:column; align-items:center; justify-content:center; text-align:center;">
                                <div style="background:#fff; padding:20px; border-radius:12px; box-shadow:0 10px 25px rgba(0,0,0,0.1); border:1px solid #e2e8f0; max-width:80%;">
                                    <div style="font-size:32px; margin-bottom:10px;">🚀</div>
                                    <h4 style="margin:0 0 5px 0; color:#0f172a;"><?php esc_html_e('Google Play Store (TWA)', 'blyxxa-core'); ?></h4>
                                    <p style="margin:0 0 15px 0; font-size:13px; color:#64748b; line-height:1.4;">
                                        <?php esc_html_e('Unlock Play Store verification and publish your app natively.', 'blyxxa-core'); ?>
                                    </p>
                                    <a href="<?php echo esc_url(BLYXXA_PLUGIN_SALES_URL); ?>" target="_blank" class="button button-primary" style="background:#ef4444; border-color:#ef4444; width:100%;">
                                        <?php esc_html_e('Upgrade to Pro', 'blyxxa-core'); ?>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div style="<?php echo esc_attr($blur_style); ?>">
                            <div style="margin-bottom:15px;">
                                <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Android Package Name', 'blyxxa-core'); ?></label>
                                <input type="text" name="blyxxa_pwa_assetlinks_package" value="<?php echo esc_attr($pwa_package); ?>" class="widefat" placeholder="com.example.app" <?php disabled(!$is_premium); ?>>
                            </div>

                            <div style="margin-bottom:15px;">
                                <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('SHA-256 Fingerprint(s)', 'blyxxa-core'); ?></label>
                                <textarea name="blyxxa_pwa_assetlinks_sha256" class="widefat" rows="3" placeholder="FA:C6:17:45:..." <?php disabled(!$is_premium); ?>><?php echo esc_textarea($pwa_sha256); ?></textarea>
                                <p class="description">
                                    <?php esc_html_e('Required for Trusted Web Activity (TWA) verification.', 'blyxxa-core'); ?><br>
                                    <?php esc_html_e('To find this:', 'blyxxa-core'); ?> 
                                    <strong>Google Play Console > Release > Setup > App Integrity > App Signing</strong>. 
                                    <?php esc_html_e('Copy the "SHA-256 certificate fingerprint" from the "App signing key certificate" section.', 'blyxxa-core'); ?>
                                </p>
                                </p>
                                <?php if(!empty($pwa_package) && !empty($pwa_sha256)): ?>
                                    <div style="margin-top:10px; background:#f8fafc; padding:10px; border:1px solid #e2e8f0; border-radius:6px;">
                                        <label style="display:block; font-size:12px; font-weight:600; color:#64748b; margin-bottom:5px;"><?php esc_html_e('AssetLinks URL (Submit this to Google)', 'blyxxa-core'); ?></label>
                                        <div style="display:flex; gap:10px;">
                                            <input type="text" value="<?php echo esc_url(site_url('.well-known/assetlinks.json')); ?>" class="widefat" readonly onclick="this.select();" style="background:#fff; color:#334155;">
                                            <a href="<?php echo esc_url(site_url('.well-known/assetlinks.json')); ?>" target="_blank" class="button">
                                                🔗 <?php esc_html_e('Open', 'blyxxa-core'); ?>
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- RIGHT COLUMN: VISUALS -->
                <div>
                    <h4 style="margin-top:0; color:#334155; border-bottom:1px solid #e2e8f0; padding-bottom:10px;"><?php esc_html_e('Visuals & Branding', 'blyxxa-core'); ?></h4>

                    <div style="margin-bottom:15px;">
                        <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('App Icon (512x512)', 'blyxxa-core'); ?></label>
                        <div style="display:flex; gap:10px; align-items:center;">
                            <input type="url" name="blyxxa_pwa_icon" id="blyxxa_pwa_icon" value="<?php echo esc_url($pwa_icon); ?>" class="widefat" placeholder="<?php echo esc_attr(get_site_icon_url(512)); ?>">
                            <button type="button" class="button" id="blyxxa_upload_icon_btn"><?php esc_html_e('Upload', 'blyxxa-core'); ?></button>
                        </div>
                        <p class="description"><?php esc_html_e('Must be a square PNG image, at least 512x512 pixels.', 'blyxxa-core'); ?></p>
                    </div>

                    <div style="margin-bottom:15px; background:#f0f9ff; padding:15px; border-radius:8px; border:1px solid #bae6fd;">
                        <label style="display:block; font-weight:600; margin-bottom:5px; color:#0369a1;"><?php esc_html_e('Splash Screen Icon', 'blyxxa-core'); ?></label>
                        <div style="display:flex; gap:10px; align-items:center;">
                            <input type="url" name="blyxxa_pwa_splash_icon" id="blyxxa_pwa_splash_icon" value="<?php echo esc_url($pwa_splash_icon); ?>" class="widefat" placeholder="https://...">
                            <button type="button" class="button" id="blyxxa_upload_splash_btn"><?php esc_html_e('Select Image', 'blyxxa-core'); ?></button>
                        </div>
                        <p class="description" style="color:#0c4a6e;"><?php esc_html_e('Optional. An icon specifically for the startup screen. If empty, App Icon is used.', 'blyxxa-core'); ?></p>
                    </div>

                    <div style="margin-bottom:15px;">
                        <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Default Tool Icon', 'blyxxa-core'); ?></label>
                        <div style="display:flex; gap:10px; align-items:center;">
                            <input type="url" name="blyxxa_pwa_default_tool_icon" id="blyxxa_pwa_default_tool_icon" value="<?php echo esc_url($pwa_default_tool_icon); ?>" class="widefat" placeholder="https://...">
                            <button type="button" class="button" id="blyxxa_upload_tool_icon_btn"><?php esc_html_e('Select Image', 'blyxxa-core'); ?></button>
                        </div>
                        <p class="description"><?php esc_html_e('Used for tools that do not have a Featured Image. Default is a lightning bolt.', 'blyxxa-core'); ?></p>
                    </div>

                    <div style="display:flex; gap:20px; margin-bottom:15px;">
                        <div style="flex:1;">
                            <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Theme Color', 'blyxxa-core'); ?></label>
                            <input type="color" name="blyxxa_pwa_theme_color" value="<?php echo esc_attr($pwa_theme_color); ?>" style="width:100%; height:40px;">
                            <p class="description"><?php esc_html_e('Browser toolbar color.', 'blyxxa-core'); ?></p>
                        </div>
                        <div style="flex:1;">
                            <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Background Color', 'blyxxa-core'); ?></label>
                            <input type="color" name="blyxxa_pwa_bg_color" value="<?php echo esc_attr($pwa_bg_color); ?>" style="width:100%; height:40px;">
                            <p class="description"><?php esc_html_e('Splash screen background.', 'blyxxa-core'); ?></p>
                        </div>
                    </div>

                    <div style="margin-top:20px;">
                        <label style="display:flex; align-items:center; gap:10px; font-weight:600;">
                            <input type="checkbox" name="blyxxa_pwa_ios_status" value="1" <?php checked($ios_status, '1'); ?>>
                            <?php esc_html_e('Enable iOS Install Guide', 'blyxxa-core'); ?>
                        </label>
                        <p class="description"><?php esc_html_e('Shows a helper tooltip for iPhone/iPad users to install the app via "Add to Home Screen".', 'blyxxa-core'); ?></p>
                    </div>
                </div>
            </div>

            <!-- PWABuilder Guide -->
            <div style="margin-top:40px; background:#fff; border:1px solid #e2e8f0; border-radius:12px; overflow:hidden;">
                <div style="background:#f8fafc; padding:15px 20px; border-bottom:1px solid #e2e8f0; cursor:pointer; display:flex; justify-content:space-between; align-items:center;" onclick="document.getElementById('blyxxa_pwabuilder_guide').style.display = (document.getElementById('blyxxa_pwabuilder_guide').style.display === 'none' ? 'block' : 'none');">
                    <h4 style="margin:0; color:#334155;">🚀 <?php esc_html_e('How to Create APK/AAB for Play Store (PWABuilder)', 'blyxxa-core'); ?></h4>
                    <span style="color:#94a3b8;">▼</span>
                </div>
                <div id="blyxxa_pwabuilder_guide" style="display:none; padding:20px; color:#475569; font-size:14px; line-height:1.6;">
                    <p><?php esc_html_e('Follow these steps to generate your Android App Bundle (AAB) for Google Play Store using PWABuilder:', 'blyxxa-core'); ?></p>
                    <ol style="margin-left:20px;">
                        <li>
                            <strong><?php esc_html_e('Go to PWABuilder:', 'blyxxa-core'); ?></strong> 
                            <?php esc_html_e('Visit', 'blyxxa-core'); ?> <a href="https://www.pwabuilder.com" target="_blank">pwabuilder.com</a>.
                        </li>
                        <li>
                            <strong><?php esc_html_e('Enter URL:', 'blyxxa-core'); ?></strong> 
                            <?php esc_html_e('Enter your website URL (must be HTTPS) and click "Start".', 'blyxxa-core'); ?>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Analyze:', 'blyxxa-core'); ?></strong> 
                            <?php esc_html_e('Wait for the analysis to complete. Ensure you have a high score (Manifest and Service Worker should be present).', 'blyxxa-core'); ?>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Build for Store:', 'blyxxa-core'); ?></strong> 
                            <?php esc_html_e('Click "Package for Stores" or "Build My PWA". Select "Android".', 'blyxxa-core'); ?>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Configure Options:', 'blyxxa-core'); ?></strong>
                            <ul style="list-style:disc; margin-left:20px; margin-top:5px;">
                                <li><?php esc_html_e('**Signing Key:** For a new app, let PWABuilder generate a new signing key. For updates, you MUST upload your existing key.', 'blyxxa-core'); ?></li>
                                <li><?php esc_html_e('**Package ID:** Use the same Package Name you entered above (e.g., com.example.app).', 'blyxxa-core'); ?></li>
                                <li><?php esc_html_e('**App Name & Version:** Fill in your app details.', 'blyxxa-core'); ?></li>
                                <li><?php esc_html_e('**Asset Links:** PWABuilder might ask for the SHA-256 fingerprint. You can find it in the Google Play Console as described above.', 'blyxxa-core'); ?></li>
                            </ul>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Download:', 'blyxxa-core'); ?></strong> 
                            <?php esc_html_e('Click "Generate" to download your package. You will get a ZIP file containing both APK (for testing) and AAB (for Play Store).', 'blyxxa-core'); ?>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Upload to Play Console:', 'blyxxa-core'); ?></strong> 
                            <?php esc_html_e('Go to Google Play Console > Release > Production (or Testing) and upload the .aab file.', 'blyxxa-core'); ?>
                        </li>
                    </ol>
                    <p style="background:#fff3cd; color:#856404; padding:10px; border-radius:6px; border:1px solid #ffeeba;">
                        <strong><?php esc_html_e('Important:', 'blyxxa-core'); ?></strong> 
                        <?php esc_html_e('After uploading your AAB to Play Console, Google will generate the final SHA-256 fingerprint. Make sure to copy that fingerprint back to the "SHA-256 Fingerprint" field above and save settings to complete the AssetLinks verification.', 'blyxxa-core'); ?>
                    </p>
                </div>
            </div>

            <div style="text-align:right; margin-top:30px; border-top:1px solid #e2e8f0; padding-top:20px;">
                <button type="submit" name="blyxxa_save_pwa" class="button button-primary button-large"><?php esc_html_e('Save PWA Settings', 'blyxxa-core'); ?></button>
            </div>
        </form>
    </div>

    <script>
    jQuery(document).ready(function($){
        // Enqueue Media Uploader
        function blyxxa_media_upload(btnId, inputId) {
            $(btnId).click(function(e) {
                e.preventDefault();
                var image = wp.media({ 
                    title: '<?php echo esc_js(__('Select Image', 'blyxxa-core')); ?>',
                    multiple: false
                }).open()
                .on('select', function(e){
                    var uploaded_image = image.state().get('selection').first();
                    var image_url = uploaded_image.toJSON().url;
                    $(inputId).val(image_url);
                });
            });
        }
        
        // Init Uploaders
        blyxxa_media_upload('#blyxxa_upload_splash_btn', '#blyxxa_pwa_splash_icon');
        blyxxa_media_upload('#blyxxa_upload_tool_icon_btn', '#blyxxa_pwa_default_tool_icon');
        
        // Also fix the App Icon button if it doesn't have an ID
        $('#blyxxa_pwa_icon').next('.button').attr('id', 'blyxxa_upload_icon_btn');
        blyxxa_media_upload('#blyxxa_upload_icon_btn', '#blyxxa_pwa_icon');
    });
    </script>
    <?php
}
