<?php
// BLYXXA BRANDING DASHBOARD

function blyxxa_dashboard_page() {
    $current_user = wp_get_current_user();
    
    // 1. SAVE SETTINGS
    if (isset($_POST['blyxxa_save_config']) && check_admin_referer('blyx_config_save')) {
        if(isset($_POST['blyxxa_payment_link'])) update_option('blyxxa_payment_link', esc_url_raw(wp_unslash($_POST['blyxxa_payment_link'])));
        
        // Branding Save
        if(isset($_POST['blyxxa_brand_name'])) update_option('blyxxa_brand_name', sanitize_text_field(wp_unslash($_POST['blyxxa_brand_name'])));
        if(isset($_POST['blyxxa_brand_logo'])) update_option('blyxxa_brand_logo', esc_url_raw(wp_unslash($_POST['blyxxa_brand_logo'])));
        if(isset($_POST['blyxxa_brand_footer'])) update_option('blyxxa_brand_footer', sanitize_text_field(wp_unslash($_POST['blyxxa_brand_footer'])));
        if(isset($_POST['blyxxa_brand_color'])) update_option('blyxxa_brand_color', sanitize_hex_color(wp_unslash($_POST['blyxxa_brand_color'])));
        
        // New settings from the diff
        if(isset($_POST['blyxxa_gumroad_token'])) {
            update_option('blyxxa_gumroad_token', sanitize_text_field(wp_unslash($_POST['blyxxa_gumroad_token'])));
        }
        if(isset($_POST['blyxxa_gumroad_product_id'])) {
            update_option('blyxxa_gumroad_product_id', sanitize_text_field(wp_unslash($_POST['blyxxa_gumroad_product_id'])));
        }
        if(isset($_POST['gumroad_plugin_product_id'])) {
            update_option('blyxxa_gumroad_plugin_product_id', sanitize_text_field(wp_unslash($_POST['gumroad_plugin_product_id'])));
        }
        if(isset($_POST['blyxxa_master_prompt'])) {
            update_option('blyxxa_master_prompt', wp_kses_post(wp_unslash($_POST['blyxxa_master_prompt'])));
        }

        echo '<div class="notice notice-success is-dismissible"><p style="color:#333;">✅ ' . esc_html__('Settings Saved!', 'blyxxa-core') . '</p></div>';
    }
    
    // 1.5 AUTO-SETUP RUNNER
    if(isset($_POST['blyxxa_run_setup']) && check_admin_referer('blyx_config_save')) {
        $pages = [
            __('Blyxxa Login', 'blyxxa-core')     => '[blyxxa_login]',
            __('Blyxxa Register', 'blyxxa-core')  => '[blyxxa_register]',
            __('Blyxxa Dashboard', 'blyxxa-core') => '[blyxxa_dashboard]',
            __('Blyxxa Profile', 'blyxxa-core')   => '[blyxxa_profile]',
            __('Blyxxa History', 'blyxxa-core')   => '[blyxxa_history]'
        ];

        $created = 0;
        foreach ($pages as $title => $content) {
            $args = array(
                'title' => $title,
                'post_type' => 'page',
                'post_status' => 'publish',
                'posts_per_page' => 1
            );
            $query = new WP_Query($args);
            $page_check = $query->have_posts() ? $query->posts[0] : null;
            
            if (!$page_check) {
                $page_id = wp_insert_post([
                    'post_title'   => $title,
                    'post_content' => $content,
                    'post_status'  => 'publish',
                    'post_type'    => 'page',
                    'post_author'  => $current_user->ID,
                ]);
                
                if ($page_id && !is_wp_error($page_id)) {
                    $slug = sanitize_title($title);
                    update_option("blyxxa_page_id_$slug", $page_id);
                    $created++;
                }
            }
        }
        
        if($created > 0) {
            echo '<div class="notice notice-success is-dismissible"><p>✅ ' . sprintf(esc_html__('Setup Complete! %d new pages created.', 'blyxxa-core'), $created) . '</p></div>';
        } else {
            echo '<div class="notice notice-info is-dismissible"><p>ℹ️ ' . esc_html__('All pages already exist. No changes made.', 'blyxxa-core') . '</p></div>';
        }
    }

    
    // 2. SEND FEEDBACK
    if (isset($_POST['blyxxa_send_feedback']) && check_admin_referer('blyx_feedback_send')) {
        $subject = isset($_POST['blyxxa_feedback_subject']) ? sanitize_text_field(wp_unslash($_POST['blyxxa_feedback_subject'])) : '';
        $message = isset($_POST['blyxxa_feedback_message']) ? sanitize_textarea_field(wp_unslash($_POST['blyxxa_feedback_message'])) : '';
        
        if(class_exists('Blyxxa_Client_License') && Blyxxa_Client_License::send_feedback($subject, $message)) {
            echo '<div class="notice notice-success is-dismissible"><p style="color:#333;">✅ ' . esc_html__('Feedback Sent! Thank you.', 'blyxxa-core') . '</p></div>';
        } else {
             echo '<div class="notice notice-error is-dismissible"><p style="color:#333;">❌ ' . esc_html__('Failed to send feedback. Please check your connection.', 'blyxxa-core') . '</p></div>';
        }
    }

    // Get current options
    $gumroad_token = get_option('blyxxa_gumroad_token', '');
    $gumroad_product_id = get_option('blyxxa_gumroad_product_id', '');
    $gumroad_plugin_product_id = get_option('blyxxa_gumroad_plugin_product_id', '');
    
    // Branding Options
    // Dynamic Branding (Synced from Master)
    $branding = get_option('blyxxa_client_branding', []);
    $brand_name = $branding['name'] ?? 'Blyxxa Labs';
    $brand_logo = $branding['logo'] ?? '';
    $brand_footer = $branding['footer'] ?? '© 2024 Blyxxa Labs. All rights reserved.';
    $brand_color = $branding['color'] ?? '#3ba1da';
    
    // System Checks
    $engine_status = function_exists('blyxxa_handle_webhook_v2') ? '<span style="color:#10b981;">● ' . __('Active', 'blyxxa-core') . '</span>' : '<span style="color:red;">● ' . __('Inactive', 'blyxxa-core') . '</span>';
    $ai_status = (get_user_meta($current_user->ID, 'blyxxa_gemini_key', true) || get_user_meta($current_user->ID, 'blyxxa_openai_key', true)) ? '<span style="color:#10b981;">● ' . __('Connected', 'blyxxa-core') . '</span>' : '<span style="color:#f59e0b;">● ' . __('No API Keys', 'blyxxa-core') . '</span>';
    $tools_count = count(glob(BLYXXA_TOOLS_PATH . '*.php'));
    
    // Tabs Logic
    $active_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'overview';
    ?>
    <style>
        .blyx-dash-wrap { font-family: 'Inter', sans-serif; max-width: 1200px; margin: 20px auto; }
        .blyx-header { background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%); color: #fff; padding: 40px; border-radius: 16px; border-bottom: 5px solid #06b6d4; box-shadow: 0 10px 25px rgba(0,0,0,0.2); display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .blyx-logo h1 { font-size: 32px; font-weight: 800; margin: 0; color: #fff; letter-spacing: -1px; }
        .blyx-logo span { color: #06b6d4; }
        .blyx-subtitle { opacity: 0.7; font-size: 16px; margin-top: 5px; font-weight: 400; }
        .nav-tab-wrapper { border-bottom: 1px solid #e2e8f0; margin-bottom: 20px; }
        .nav-tab { background: #fff; border: 1px solid #e2e8f0; border-bottom: none; color: #64748b; font-weight: 600; padding: 10px 20px; margin-right: 5px; border-radius: 8px 8px 0 0; transition: 0.2s; }
        .nav-tab:hover { background: #f8fafc; color: #0f172a; }
        .nav-tab-active { background: #fff; color: #06b6d4; border-bottom: 1px solid #fff; margin-bottom: -1px; box-shadow: 0 -2px 5px rgba(0,0,0,0.02); }
        .blyx-card { background: #fff; border: 1px solid #e2e8f0; border-radius: 12px; padding: 25px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); margin-bottom: 20px; }
        .blyx-card h3 { margin-top: 0; border-bottom: 1px solid #f1f5f9; padding-bottom: 15px; color: #0f172a; font-size: 18px; }
        .blyx-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .blyx-full-card { grid-column: 1 / -1; }
        .blyx-btn-link { display: inline-block; background: #0f172a; color: #fff; text-decoration: none; padding: 10px 20px; border-radius: 6px; font-weight: 600; font-size: 14px; transition: 0.2s; text-align:center; }
        .blyx-btn-link:hover { background: #06b6d4; color: #fff; }
        
        /* Fix Admin Notice Visibility */
        .notice, .updated, .error { color: #333 !important; }
        .notice p, .updated p, .error p { color: #333 !important; }
    </style>

    <div class="wrap blyx-dash-wrap">
        <div class="blyx-header">
            <div class="blyx-logo">
                <h1>Blyxxa<span>Core</span></h1>
                <div class="blyx-subtitle"><?php esc_html_e('Digital Kits & Smart Content Tools', 'blyxxa-core'); ?></div>
            </div>
            <div style="text-align: right;">
                <div style="font-size: 12px; opacity: 0.6; text-transform: uppercase; letter-spacing: 1px;"><?php esc_html_e('Licensed To', 'blyxxa-core'); ?></div>
                <div style="font-size: 18px; font-weight: 700;"><?php esc_html_e('Blyxxa LLC', 'blyxxa-core'); ?></div>
            </div>
        </div>

        <?php 
        // Grace Period Warning
        if (get_transient('blyxxa_connection_warning')) {
            echo '<div class="notice notice-warning inline" style="margin: 20px 0; border-left-color: #f59e0b;">
                <p><strong>⚠️ ' . esc_html__('Offline Mode', 'blyxxa-core') . ':</strong> ' . esc_html__('Unable to connect to the license server. You are in a 72-hour grace period. Please check your internet connection.', 'blyxxa-core') . '</p>
            </div>';
        }
        
        // Broadcast Logic
        $broadcasts = get_option('blyxxa_client_broadcasts', []);
        $read_log = get_option('blyxxa_broadcast_read_log', []);
        $unread_count = 0;
        if(is_array($broadcasts)) {
            foreach($broadcasts as $b) {
                if(!in_array($b['id'], $read_log)) $unread_count++;
            }
        }
        
        // Handle Mark as Read
        if(isset($_POST['mark_read_id']) && check_admin_referer('blyx_mark_read')) {
            $read_id = intval($_POST['mark_read_id']);
            if(!in_array($read_id, $read_log)) {
                $read_log[] = $read_id;
                update_option('blyxxa_broadcast_read_log', $read_log);
                $unread_count--; // Update count immediately for display
            }
        }
        ?>

        <h2 class="nav-tab-wrapper">
            <a href="?page=blyxxa-hq&tab=overview" class="nav-tab <?php echo $active_tab == 'overview' ? 'nav-tab-active' : ''; ?>">📊 <?php esc_html_e('Overview', 'blyxxa-core'); ?></a>
            <a href="?page=blyxxa-hq&tab=announcements" class="nav-tab <?php echo $active_tab == 'announcements' ? 'nav-tab-active' : ''; ?>">
                📢 <?php esc_html_e('Announcements', 'blyxxa-core'); ?>
                <?php if($unread_count > 0): ?>
                <span style="background:#ef4444; color:#fff; font-size:10px; padding:2px 6px; border-radius:10px; vertical-align:top; margin-left:5px;"><?php echo esc_html($unread_count); ?></span></span>
                <?php endif; ?>
            </a>
            <a href="?page=blyxxa-hq&tab=subscription" class="nav-tab <?php echo $active_tab == 'subscription' ? 'nav-tab-active' : ''; ?>">💳 <?php esc_html_e('License Status', 'blyxxa-core'); ?></a>
            <a href="?page=blyxxa-hq&tab=config" class="nav-tab <?php echo $active_tab == 'config' ? 'nav-tab-active' : ''; ?>">⚙️ <?php esc_html_e('Configuration', 'blyxxa-core'); ?></a>
            <a href="?page=blyxxa-hq&tab=branding" class="nav-tab <?php echo $active_tab == 'branding' ? 'nav-tab-active' : ''; ?>">🎨 <?php esc_html_e('Branding', 'blyxxa-core'); ?></a>
            <a href="?page=blyxxa-hq&tab=pwa" class="nav-tab <?php echo $active_tab == 'pwa' ? 'nav-tab-active' : ''; ?>">📱 <?php esc_html_e('PWA / TWA', 'blyxxa-core'); ?></a>
            <a href="?page=blyxxa-hq&tab=support" class="nav-tab <?php echo $active_tab == 'support' ? 'nav-tab-active' : ''; ?>">🆘 <?php esc_html_e('Support', 'blyxxa-core'); ?></a>
            <a href="?page=blyxxa-hq&tab=changelog" class="nav-tab <?php echo $active_tab == 'changelog' ? 'nav-tab-active' : ''; ?>">📜 <?php esc_html_e('What\'s New', 'blyxxa-core'); ?></a>
        </h2>

        <?php if ($active_tab == 'overview'): ?>
            <div class="blyx-grid">
                <div class="blyx-card">
                    <h3>🏭 <?php esc_html_e('Tool Factory', 'blyxxa-core'); ?></h3>
                    <p style="color:#64748b;"><?php esc_html_e('Create new AI tools with zero coding using the Master Prompt engine.', 'blyxxa-core'); ?></p>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=blyxxa-tool-factory')); ?>" class="blyx-btn-link"><?php esc_html_e('Open Generator', 'blyxxa-core'); ?></a>
                </div>

                <div class="blyx-card">
                    <h3>📂 <?php esc_html_e('Tool Manager', 'blyxxa-core'); ?></h3>
                    <?php /* translators: %s: number of active tools */ ?>
                    <p style="color:#64748b;"><?php echo wp_kses_post(sprintf(__('Manage your modular tools. Currently running: <strong>%s</strong> active tools.', 'blyxxa-core'), esc_html($tools_count))); ?></p>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=blyxxa-tool-manager')); ?>" class="blyx-btn-link" style="background: #fff; color: #0f172a; border: 1px solid #cbd5e1;"><?php esc_html_e('Manage Files', 'blyxxa-core'); ?></a>
                </div>

                <div class="blyx-card">
                    <h3>⚡ <?php esc_html_e('System Health', 'blyxxa-core'); ?></h3>
                    <div class="blyx-stat-row">
                        <span><?php esc_html_e('Core Engine', 'blyxxa-core'); ?></span>
                        <strong><?php echo wp_kses_post($engine_status); ?></strong>
                    </div>
                    <div class="blyx-stat-row">
                        <span><?php esc_html_e('Webhook Listener', 'blyxxa-core'); ?></span>
                        <strong>/blyxxa/v1/webhook</strong>
                    </div>
                    <div class="blyx-stat-row">
                        <span><?php esc_html_e('AI Connections', 'blyxxa-core'); ?></span>
                        <strong><?php echo wp_kses_post($ai_status); ?></strong>
                    </div>
                </div>

                <div class="blyx-card blyx-full-card">
                    <h3>📚 <?php esc_html_e('Shortcodes & Help', 'blyxxa-core'); ?></h3>
                    <div style="display:grid; grid-template-columns: 1fr 1fr; gap:20px;">
                        <div style="background:#fff; padding:15px; border:1px solid #e2e8f0; border-radius:8px;">
                            <h4 style="margin-top:0; color:#3ba1da;"><?php esc_html_e('Page Shortcodes', 'blyxxa-core'); ?></h4>
                            <ul style="font-size:13px; color:#64748b; list-style:none; padding:0;">
                                <li style="margin-bottom:5px;"><code>[blyxxa_login]</code> - <?php esc_html_e('Login Page', 'blyxxa-core'); ?></li>
                                <li style="margin-bottom:5px;"><code>[blyxxa_register]</code> - <?php esc_html_e('Register Page', 'blyxxa-core'); ?></li>
                                <li style="margin-bottom:5px;"><code>[blyxxa_dashboard]</code> - <?php esc_html_e('Main Dashboard', 'blyxxa-core'); ?></li>
                                <li style="margin-bottom:5px;"><code>[blyxxa_profile]</code> - <?php esc_html_e('Profile and Settings', 'blyxxa-core'); ?></li>
                                <li style="margin-bottom:5px;"><code>[blyxxa_history]</code> - <?php esc_html_e('History', 'blyxxa-core'); ?></li>
                            </ul>
                        </div>
                        <div style="background:#fff; padding:15px; border:1px solid #e2e8f0; border-radius:8px;">
                            <h4 style="margin-top:0; color:#3ba1da;"><?php esc_html_e('Auto-Setup', 'blyxxa-core'); ?></h4>
                            <p style="font-size:13px; color:#64748b;"><?php esc_html_e('All necessary pages have been created automatically. You can find them in the Pages section.', 'blyxxa-core'); ?></p>
                            <div style="display:flex; gap:10px; margin-top:10px;">
                                <a href="edit.php?post_type=page" target="_blank" class="button"><?php esc_html_e('View All Pages', 'blyxxa-core'); ?></a>
                                <form method="post" action="" style="margin:0;">
                                    <?php wp_nonce_field('blyx_config_save'); ?>
                                    <button type="submit" name="blyxxa_run_setup" class="button button-primary" onclick="return confirm('<?php echo esc_js(__('Create missing pages?', 'blyxxa-core')); ?>')"><?php esc_html_e('Run Auto-Setup', 'blyxxa-core'); ?></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        <?php elseif ($active_tab == 'announcements'): ?>
            <div class="blyx-card blyx-full-card">
                <div style="display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid #f1f5f9; padding-bottom:15px; margin-bottom:15px;">
                    <h3 style="margin:0; border:none; padding:0;">📢 <?php esc_html_e('Announcements', 'blyxxa-core'); ?></h3>
                    <form method="post" style="margin:0;">
                        <?php wp_nonce_field('blyx_refresh_data'); ?>
                        <button type="submit" name="blyxxa_refresh_data" class="button button-secondary">🔄 <?php esc_html_e('Refresh', 'blyxxa-core'); ?></button>
                    </form>
                </div>
                
                <?php if(empty($broadcasts) || !is_array($broadcasts)): ?>
                    <p style="color:#64748b;"><?php esc_html_e('No announcements yet.', 'blyxxa-core'); ?></p>
                <?php else: ?>
                    <div style="display:flex; flex-direction:column; gap:15px;">
                    <?php foreach($broadcasts as $b): 
                        $is_read = in_array($b['id'], $read_log);
                        $bg_color = $is_read ? '#f8fafc' : '#fff';
                        $border_color = $is_read ? '#e2e8f0' : '#3ba1da';
                        $opacity = $is_read ? '0.7' : '1';
                    ?>
                        <div style="background:<?php echo esc_attr($bg_color); ?>; border:1px solid <?php echo esc_attr($border_color); ?>; padding:20px; border-radius:8px; opacity:<?php echo esc_attr($opacity); ?>; position:relative;">
                            <?php if(!$is_read): ?>
                                <span style="position:absolute; top:10px; right:10px; background:#ef4444; color:#fff; font-size:10px; padding:2px 6px; border-radius:4px;"><?php esc_html_e('NEW', 'blyxxa-core'); ?></span>
                            <?php endif; ?>
                            
                            <h4 style="margin-top:0; margin-bottom:5px; color:#1e293b;">
                                <?php echo esc_html($b['title']); ?> 
                                <span style="font-size:11px; font-weight:normal; color:#94a3b8; margin-left:10px;"><?php echo esc_html(gmdate('M j, Y', strtotime($b['created_at']))); ?></span>
                            </h4>
                            
                            <div style="font-size:14px; color:#475569; line-height:1.6;">
                                <?php echo wp_kses_post($b['message']); ?>
                            </div>
                            
                            <?php if(!$is_read): ?>
                            <form method="post" style="margin-top:10px;">
                                <?php wp_nonce_field('blyx_mark_read'); ?>
                                <input type="hidden" name="mark_read_id" value="<?php echo esc_attr($b['id']); ?>">
                                <button type="submit" class="button button-small"><?php esc_html_e('Mark as Read', 'blyxxa-core'); ?></button>
                            </form>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>

        <?php elseif ($active_tab == 'subscription'): ?>
            <div class="blyx-card">
                <h3>🔑 <?php esc_html_e('Plugin Subscription', 'blyxxa-core'); ?></h3>
                <?php 
                $user_email = get_option('blyxxa_user_email', ''); 
                $sub_status = get_option('blyxxa_client_sub_status', []);
                $status_color = ($sub_status['status'] ?? '') === 'active' ? '#10b981' : '#ef4444';
                ?>
                
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:20px;">
                    <div>
                        <form method="post" action="">
                            <?php wp_nonce_field('blyx_activate_license'); ?>
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('Registered Email Address or License Key', 'blyxxa-core'); ?></label>
                            <p style="font-size:12px; color:#64748b; margin-bottom:10px;"><?php esc_html_e('Enter the email address (Gumroad) or License Key.', 'blyxxa-core'); ?></p>
                            <div style="display:flex; gap:10px;">
                                <input type="text" name="blyxxa_user_email" value="<?php echo esc_attr($user_email); ?>" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px;" placeholder="you@example.com OR License Key" required>
                                <button type="submit" name="blyxxa_activate_license" class="button button-primary" style="background:#0f172a;"><?php esc_html_e('Verify Subscription', 'blyxxa-core'); ?></button>
                                <button type="button" onclick="testConnection()" class="button" title="<?php esc_attr_e('Check connection to License Server', 'blyxxa-core'); ?>">📡 <?php esc_html_e('Test Connection', 'blyxxa-core'); ?></button>
                            </div>
                        </form>
                        <div id="connection_status" style="margin-top:10px; font-size:12px; display:none;"></div>
                        <script>
                        function testConnection() {
                            let status = document.getElementById('connection_status');
                            status.style.display = 'block';
                            status.innerHTML = '<span style="color:#f59e0b;"><?php echo esc_js(__('Connecting to Master Node...', 'blyxxa-core')); ?></span>';
                            fetch('<?php echo esc_url(BLYXXA_MASTER_API_URL); ?>/webhook')
                                .then(response => { if(response.ok) return response.json(); throw new Error('Network response was not ok'); })
                                .then(data => { 
                                    if(data.status === 'success') status.innerHTML = '<span style="color:#10b981;">✅ <?php echo esc_js(__('Connection Successful!', 'blyxxa-core')); ?></span>';
                                    else status.innerHTML = '<span style="color:#ef4444;">❌ <?php echo esc_js(__('Connected but invalid response.', 'blyxxa-core')); ?></span>';
                                })
                                .catch(error => { status.innerHTML = '<span style="color:#ef4444;">❌ <?php echo esc_js(__('Connection Failed: ', 'blyxxa-core')); ?>' + error.message + '</span>'; });
                        }
                        </script>
                        
                        <?php if($user_email): ?>
                        <form method="post" action="" style="margin-top:10px;">
                            <?php wp_nonce_field('blyx_deactivate_license'); ?>
                            <button type="submit" name="blyxxa_deactivate_license" class="button button-link-delete"><?php esc_html_e('Reset License', 'blyxxa-core'); ?></button>
                        </form>
                        <?php endif; ?>
                    </div>
                    
                    <div style="background:#f8fafc; padding:15px; border-radius:8px; border:1px solid #e2e8f0;">
                        <h4 style="margin-top:0; color:#334155;"><?php esc_html_e('Subscription Status', 'blyxxa-core'); ?></h4>
                        <?php if($user_email): ?>
                            <div style="font-size:14px; margin-bottom:5px;">
                                <?php esc_html_e('Status:', 'blyxxa-core'); ?> <strong style="color:<?php echo esc_attr($status_color); ?>"><?php echo esc_html(strtoupper($sub_status['status'] ?? 'UNKNOWN')); ?></strong>
                            </div>
                            <div style="font-size:13px; color:#64748b;">
                                <?php esc_html_e('Account:', 'blyxxa-core'); ?> <?php echo esc_html($user_email); ?>
                            </div>
                        <?php else: ?>
                            <p style="color:#64748b; font-size:13px; margin-bottom:10px;"><?php esc_html_e('Please verify your subscription to unlock the Tool Factory.', 'blyxxa-core'); ?></p>
                            <a href="<?php echo esc_url(BLYXXA_PLUGIN_SALES_URL); ?>" target="_blank" class="button button-primary" style="background:#ef4444; border-color:#ef4444; width:100%; text-align:center;">
                                <?php esc_html_e('Subscribe Now', 'blyxxa-core'); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>



        <?php elseif ($active_tab == 'config'): ?>
            <div class="blyx-card">
                <h3>⚙️ <?php esc_html_e('Gumroad Configuration', 'blyxxa-core'); ?></h3>
                <form method="post" action="">
                    <?php wp_nonce_field('blyx_config_save'); ?>
                    
                    <div style="background:#f0f9ff; padding:15px; border-left:4px solid #0ea5e9; margin-bottom:20px; border-radius:4px;">
                        <h4 style="margin-top:0; color:#0369a1;"><?php esc_html_e('How to Sell Your Tools with Gumroad', 'blyxxa-core'); ?></h4>
                        <ol style="font-size:13px; color:#334155; padding-left:20px; margin:0;">
                            <li><?php esc_html_e('Create a product on Gumroad (Membership or Digital Product).', 'blyxxa-core'); ?></li>
                            <li><?php echo wp_kses_post(__('Go to <strong>Settings > Advanced > Applications</strong> in Gumroad to get your <strong>Access Token</strong>.', 'blyxxa-core')); ?></li>
                            <li><?php esc_html_e('Enter the Access Token below.', 'blyxxa-core'); ?></li>
                            <li><?php echo wp_kses_post(__('Copy the <strong>Webhook URL</strong> below and paste it into your Gumroad Product\'s <strong>Settings > Ping (Webhook)</strong> field.', 'blyxxa-core')); ?></li>
                            <li><?php echo wp_kses_post(__('Enter your <strong>SaaS Product ID</strong> (the ID of the product you created) below.', 'blyxxa-core')); ?></li>
                        </ol>
                    </div>

                    <div style="display:grid; grid-template-columns: 1fr 1fr; gap:20px; margin-bottom:20px;">
                        <div>
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('Gumroad Access Token', 'blyxxa-core'); ?></label>
                            <input type="password" name="blyxxa_gumroad_token" value="<?php echo esc_attr($gumroad_token); ?>" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px; color:#334155;" placeholder="ipns_...">
                        </div>
                        <div>
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('SaaS Product ID (Membership)', 'blyxxa-core'); ?></label>
                            <input type="text" name="blyxxa_gumroad_product_id" value="<?php echo esc_attr($gumroad_product_id); ?>" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px; color:#334155;" placeholder="e.g. XyZ12">
                        </div>
                        <div style="grid-column: 1 / -1;">
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('Webhook Endpoint (Paste into Gumroad)', 'blyxxa-core'); ?></label>
                            <div style="display:flex; gap:10px;">
                                <input type="text" value="<?php echo esc_url(site_url('wp-json/blyxxa/v1/webhook')); ?>" readonly onclick="this.select()" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px; color:#334155; background:#f1f5f9; font-family:monospace;">
                                <button type="button" onclick="blyxxaCopy(this, '<?php echo esc_js(site_url('wp-json/blyxxa/v1/webhook')); ?>')" class="button" style="height:auto;"><?php esc_html_e('Copy', 'blyxxa-core'); ?></button>
                            </div>
                        </div>
                        <div style="grid-column: 1 / -1;">
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('Payment Link (Buy Button)', 'blyxxa-core'); ?></label>
                            <input type="url" name="blyxxa_payment_link" value="<?php echo esc_url(get_option('blyxxa_payment_link', '')); ?>" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px;" placeholder="https://gumroad.com/l/your-product">
                            <p style="font-size:12px; color:#64748b; margin-top:5px;"><?php esc_html_e('This link will be shown to users in the dashboard if they don\'t have an active subscription.', 'blyxxa-core'); ?></p>
                        </div>
                    </div>
                    
                    <div style="text-align:right; margin-bottom:30px;">
                        <button type="submit" name="blyxxa_save_config" class="button button-primary"><?php esc_html_e('Save Gumroad Settings', 'blyxxa-core'); ?></button>
                    </div>
                </form>
            </div>

        <?php elseif ($active_tab == 'branding'): ?>
            <div class="blyx-card">
                <h3>🎨 <?php esc_html_e('Branding Settings', 'blyxxa-core'); ?></h3>
                <form method="post" action="">
                    <?php wp_nonce_field('blyx_config_save'); ?>
                    <div style="display:grid; grid-template-columns: 1fr 1fr; gap:20px;">
                        <div>
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('Brand Name', 'blyxxa-core'); ?></label>
                            <input type="text" name="blyxxa_brand_name" value="<?php echo esc_attr($brand_name); ?>" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px;">
                        </div>
                        <div>
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('Brand Logo URL', 'blyxxa-core'); ?></label>
                            <input type="url" name="blyxxa_brand_logo" value="<?php echo esc_url($brand_logo); ?>" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px;" placeholder="https://...">
                        </div>
                        <div>
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('Primary Color', 'blyxxa-core'); ?></label>
                            <input type="color" name="blyxxa_brand_color" value="<?php echo esc_attr($brand_color); ?>" style="height:40px; width:100%;">
                        </div>
                        <div>
                            <label style="display:block; font-weight:600; margin-bottom:8px; color:#475569;"><?php esc_html_e('Footer Text', 'blyxxa-core'); ?></label>
                            <input type="text" name="blyxxa_brand_footer" value="<?php echo esc_attr($brand_footer); ?>" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px;">
                        </div>
                    </div>
                    <div style="text-align:right; margin-top:20px;">
                        <button type="submit" name="blyxxa_save_config" class="button button-primary" style="background:#0f172a; border-color:#0f172a; padding:10px 20px; height:auto;"><?php esc_html_e('Save Branding', 'blyxxa-core'); ?></button>
                    </div>
                </form>
            </div>

        <?php elseif ($active_tab == 'pwa'): ?>
            <?php 
            if(function_exists('blyxxa_pwa_manager_page')) {
                blyxxa_pwa_manager_page();
            } else {
                echo '<div class="notice notice-error"><p>' . esc_html__('PWA Module not loaded.', 'blyxxa-core') . '</p></div>';
            }
            ?>

        <?php elseif ($active_tab == 'support'): ?>
            <div class="blyx-card">
                <h3>🆘 <?php esc_html_e('Support & Feedback', 'blyxxa-core'); ?></h3>
                <div class="notice notice-warning inline" style="margin:0 0 20px 0;">
                    <p><?php esc_html_e('Note: This form uses your server\'s mail function (SMTP). If emails are not sending, please configure an SMTP plugin.', 'blyxxa-core'); ?></p>
                </div>
                
                <form method="post" action="">
                    <?php wp_nonce_field('blyx_feedback_send'); ?>
                    <div style="margin-bottom:15px;">
                        <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Subject', 'blyxxa-core'); ?></label>
                        <select name="blyxxa_feedback_subject" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px;">
                            <option value="Bug Report">🐛 <?php esc_html_e('Bug Report', 'blyxxa-core'); ?></option>
                            <option value="Feature Request">💡 <?php esc_html_e('Feature Request', 'blyxxa-core'); ?></option>
                            <option value="Tool Request">🛠️ <?php esc_html_e('Tool Request', 'blyxxa-core'); ?></option>
                            <option value="General Support">❓ <?php esc_html_e('General Support', 'blyxxa-core'); ?></option>
                        </select>
                    </div>
                    <div style="margin-bottom:15px;">
                        <label style="display:block; font-weight:600; margin-bottom:5px;"><?php esc_html_e('Message', 'blyxxa-core'); ?></label>
                        <textarea name="blyxxa_feedback_message" rows="5" style="width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px;" required placeholder="<?php esc_attr_e('Describe your request or issue...', 'blyxxa-core'); ?>"></textarea>
                    </div>
                    <button type="submit" name="blyxxa_send_feedback" class="button button-primary"><?php esc_html_e('Send Feedback', 'blyxxa-core'); ?></button>
                </form>
            </div>
            


        <?php elseif ($active_tab == 'changelog'): ?>
            <div class="blyx-card">
                <h3>📜 <?php esc_html_e('What\'s New', 'blyxxa-core'); ?></h3>
                <div style="background:#f8fafc; padding:20px; border-radius:8px; border:1px solid #e2e8f0; color:#334155; line-height:1.6;">
                    <?php 
                    $changelog = get_option('blyxxa_client_changelog', __('No changelog available yet.', 'blyxxa-core'));
                    echo wp_kses_post($changelog); 
                    ?>
                </div>
                <div style="margin-top:20px; text-align:right;">
                    <form method="post" action="">
                         <?php wp_nonce_field('blyx_refresh_data'); ?>
                         <input type="hidden" name="blyxxa_user_email" value="<?php echo esc_attr(get_option('blyxxa_user_email', '')); ?>">
                         <button type="submit" name="blyxxa_refresh_data" class="button" title="<?php esc_attr_e('Refresh Changelog', 'blyxxa-core'); ?>">🔄 <?php esc_html_e('Refresh Data', 'blyxxa-core'); ?></button>
                    </form>
                </div>
            </div>
        <?php endif; ?>

        <div style="margin-top: 40px; text-align: center; border-top: 1px solid #e2e8f0; padding-top: 20px; color: #94a3b8; font-size: 12px;">
            <p>
                <strong><?php printf(esc_html__('Powered by %s', 'blyxxa-core'), esc_html($brand_name)); ?></strong><br>
                <?php echo esc_html($brand_footer); ?><br>
                <a href="mailto:support@blyxxa.com" style="color:#06b6d4; text-decoration:none;"><?php esc_html_e('Support', 'blyxxa-core'); ?></a> | <a href="https://blyxxa.com" target="_blank" style="color:#06b6d4; text-decoration:none;"><?php esc_html_e('Website', 'blyxxa-core'); ?></a>
            </p>
        </div>
        <div style="clear:both;"></div>
    </div>
    <script>
    function blyxxaCopy(btn, text) {
        navigator.clipboard.writeText(text).then(function() {
            // Visual Feedback
            let originalText = btn.innerText;
            btn.innerText = '<?php echo esc_js(__('Copied!', 'blyxxa-core')); ?>';
            btn.style.background = '#10b981';
            btn.style.borderColor = '#10b981';
            btn.style.color = '#fff';
            
            // Reset
            setTimeout(() => {
                btn.innerText = originalText;
                btn.style.background = '';
                btn.style.borderColor = '';
                btn.style.color = '';
            }, 2000);
        }, function(err) {
            console.error('Copy failed', err);
        });
    }
    </script>
    <?php
    // Enqueue Gumroad Overlay Script
    wp_enqueue_script('gumroad-js', 'https://gumroad.com/js/gumroad.js', [], '1.0', true);
}