# 📘 Blyxxa SaaS Engine - User Manual

Welcome to the Blyxxa SaaS Engine documentation. This file tracks the features, usage instructions, and configuration details for the platform.

---

## 📱 Mobile App (PWA) System

The Blyxxa Engine comes with a built-in Progressive Web App (PWA) module that allows your SaaS to be installed as a native-like app on mobile devices.

### 1. Configuration (Admin)
Go to **Blyxxa HQ > Mobile App** to configure the global settings:
- **App Name:** The name displayed on the home screen.
- **App Icon:** Must be a 512x512 PNG image.
- **Theme Color:** The color of the browser address bar and status bar.

### 2. Configuration (Client)
Your SaaS clients can configure their own app settings via their **Dashboard > Mobile App** tab. This allows them to brand the app with their own name and icon.

### 3. App Mode Interface
When a user installs the app and opens it:
- The website Header and Footer are **hidden**.
- A **Bottom Navigation Bar** appears with 4 tabs:
  - **Overview:** The main dashboard.
  - **News:** Announcements and updates.
  - **Tools:** The Tool Catalog (see below).
  - **Settings:** User profile and app config.

---

## 🛠️ App Tool Registry (Tool Catalog)

To make your AI tools appear in the "Tools" tab of the mobile app, you must register them using the **App Tool Registry**.

### How to Add a Tool to the App:
1.  **Edit the Page:** Go to **Pages > All Pages** and click "Edit" on the page containing your tool shortcode.
2.  **Locate the Meta Box:** Look for the **"📱 Blyxxa App Settings"** box in the right sidebar.
3.  **Enable App Visibility:** Check the box **"Show in Mobile App"**.
4.  **Select Category:** Choose a category (e.g., Social Media, SEO) to group this tool in the app.
5.  **Set Icon:** Enter an emoji (e.g., 🚀, 📝) or a short text to represent the tool.
6.  **Update Page:** Click "Update" to save changes.

**Result:** The tool will now automatically appear in the PWA "Tools" tab, searchable and categorized.

---

## 🧩 Module System

The engine uses a modular architecture to ensure stability.
- **Core Modules:** Located in `includes/modules/`.
- **Client Modules:** Located in `client-dist/blyxxa-core/includes/modules/`.

**Current Modules:**
- `pwa`: Handles all mobile app functionality, manifest generation, and service workers.

---

## ⚠️ Troubleshooting

**"No Internet" Warning:**
The app includes a Service Worker that detects offline status. If a user loses connection, a red warning banner will appear. This is normal behavior to inform them that AI generation (which requires API access) will not work.

**App Not Installing:**
Ensure your site is served over **HTTPS**. PWAs require a secure connection to function.
