# Blyxxa Core - Developer Notes (Architecture Guide)

## Overview
This plugin operates on a **Master-Client Architecture**.
- **Master Node:** The central server (your installation) that holds the logic, the "Master Prompt", and manages licenses.
- **Client Node:** The distributed plugin (this folder) that connects to the Master Node to function.

## Key Components

### 1. License Manager (`includes/blyxxa-client-license.php`)
- Handles communication with the Master Node.
- **`activate_license($key)`**: Verifies the key and caches the response.
- **`get_master_prompt()`**: Fetches the AI Constitution. It uses a **24-hour transient cache** (`blyxxa_cached_master_prompt`) to ensure reliability even if the Master Node is temporarily offline.

### 2. Dashboard (`admin/blyxxa-dashboard.php`)
- Displays the License Input and Subscription Status.
- Shows Broadcast Messages and Changelogs fetched from the Master Node.
- **Dynamic Branding:** The logo, footer, and brand name are synced from the Master Node via the `blyxxa_client_branding` option.

### 3. Tool Factory (`admin/blyxxa-factory.php`)
- **CRITICAL:** This file does NOT contain the Master Prompt. It calls `Blyxxa_Client_License::get_master_prompt()`.
- If the license is invalid or the prompt cannot be fetched, the factory will **STOP** working. This is the primary security mechanism.

## How to Update
1. **Master Node:** Make changes to the core logic in your main repository.
2. **Build:** Run the build script (or manually copy files) to `client-dist/blyxxa-core`.
3. **Cleanup:** Ensure `includes/blyxxa-license-server.php` is REMOVED from the client build.
4. **Config:** Update `$api_url` in `blyxxa-client-license.php` to point to your production server.

## Troubleshooting
- **"License Error":** Check if the Master Node URL is correct and accessible.
- **"Update Failed":** Check if the `blyxxa_client_licenses` option on the Master Node contains the client's key.
